/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.mixin.accessors.PotionBrewingAccess;
import blusunrize.immersiveengineering.mixin.accessors.PotionMixAccess;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.fluids.crafting.CompoundFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.DataComponentFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PotionHelper {
    public static BiFunction<Holder<Potion>, PotionFluid.PotionBottleType, FluidIngredient> CREATE_POTION_BUILDER;

    public static SizedFluidIngredient getFluidIngredientForType(Holder<Potion> type, int amount, PotionFluid.PotionBottleType potionBottleType) {
        if ((type == Potions.WATER || type == null) && potionBottleType == PotionFluid.PotionBottleType.REGULAR) {
            return SizedFluidIngredient.of((TagKey)FluidTags.WATER, (int)amount);
        }
        DataComponentPredicate.Builder pred = DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(type));
        if (potionBottleType != null) {
            pred.expect((DataComponentType)IEDataComponents.POTION_BOTTLE_TYPE.get(), (Object)potionBottleType);
        }
        FluidIngredient fluidIngredient = DataComponentFluidIngredient.of((boolean)false, (DataComponentPredicate)pred.build(), (Holder[])new Holder[]{IEFluids.POTION});
        if (CREATE_POTION_BUILDER != null) {
            fluidIngredient = CompoundFluidIngredient.of((FluidIngredient[])new FluidIngredient[]{fluidIngredient, CREATE_POTION_BUILDER.apply(type, potionBottleType)});
        }
        return new SizedFluidIngredient(fluidIngredient, amount);
    }

    public static void applyToAllPotionRecipes(PotionRecipeProcessor out) {
        PotionBrewing brewingData = ServerLifecycleHooks.getCurrentServer() != null ? ServerLifecycleHooks.getCurrentServer().potionBrewing() : ImmersiveEngineering.proxy.getClientWorld().potionBrewing();
        for (PotionMixAccess<Potion> mixPredicate : ((PotionBrewingAccess)brewingData).getConversions()) {
            if (mixPredicate.getTo() == Potions.MUNDANE || mixPredicate.getTo() == Potions.THICK) continue;
            out.apply(mixPredicate.getTo(), mixPredicate.getFrom(), new IngredientWithSize(mixPredicate.getIngredient()));
        }
        for (IBrewingRecipe recipe : brewingData.getRecipes()) {
            if (!(recipe instanceof BrewingRecipe)) continue;
            BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
            IngredientWithSize ingredient = new IngredientWithSize(brewingRecipe.getIngredient());
            Ingredient input = brewingRecipe.getInput();
            ItemStack output = brewingRecipe.getOutput();
            if (output.getItem() != Items.POTION || input.getItems().length <= 0) continue;
            out.apply(PotionHelper.getPotion(output), PotionHelper.getPotion(input.getItems()[0]), ingredient);
        }
    }

    private static Holder<Potion> getPotion(ItemStack potion) {
        PotionContents potionData = (PotionContents)potion.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return potionData.potion().orElse(Potions.WATER);
    }

    public static interface PotionRecipeProcessor {
        public void apply(Holder<Potion> var1, Holder<Potion> var2, IngredientWithSize var3);
    }
}

