/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.common.register.IEIngredients;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SingleFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.TagFluidIngredient;

public record IngredientFluidStack(SizedFluidIngredient fluidIngredient) implements ICustomIngredient
{
    private static final MapCodec<SizedFluidIngredient> SIMPLE_SIZED_CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)NeoForgeExtraCodecs.xor((MapCodec)SingleFluidIngredient.CODEC, (MapCodec)TagFluidIngredient.CODEC).forGetter(i -> {
        Either either;
        FluidIngredient patt0$temp = i.ingredient();
        if (patt0$temp instanceof SingleFluidIngredient) {
            SingleFluidIngredient single = (SingleFluidIngredient)patt0$temp;
            either = Either.left((Object)single);
        } else {
            either = Either.right((Object)((TagFluidIngredient)i.ingredient()));
        }
        return either;
    }), (App)Codec.INT.fieldOf("amount").forGetter(SizedFluidIngredient::amount)).apply((Applicative)inst, (either, amount) -> (SizedFluidIngredient)either.map(single -> new SizedFluidIngredient((FluidIngredient)single, amount.intValue()), tag -> new SizedFluidIngredient((FluidIngredient)tag, amount.intValue()))));
    public static final MapCodec<IngredientFluidStack> MAP_CODEC = NeoForgeExtraCodecs.mapWithAlternative((MapCodec)SIMPLE_SIZED_CODEC.xmap(IngredientFluidStack::new, IngredientFluidStack::fluidIngredient), (MapCodec)SizedFluidIngredient.FLAT_CODEC.optionalFieldOf("ingredient").xmap(sizedFluidIngredient -> sizedFluidIngredient.map(IngredientFluidStack::new).orElse(null), ingredientFluidStack -> Optional.of(ingredientFluidStack.fluidIngredient)));
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientFluidStack> STREAM_CODEC = SizedFluidIngredient.STREAM_CODEC.map(IngredientFluidStack::new, IngredientFluidStack::fluidIngredient);

    public IngredientFluidStack(TagKey<Fluid> tag, int amount) {
        this(SizedFluidIngredient.of(tag, (int)amount));
    }

    @Nonnull
    public Stream<ItemStack> getItems() {
        return Arrays.stream(this.fluidIngredient.getFluids()).map(FluidUtil::getFilledBucket).filter(s -> !s.isEmpty());
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Optional<FluidStack> fluid = FluidUtils.getFluidContained(stack);
        return fluid.isPresent() && this.fluidIngredient.test(fluid.get());
    }

    public boolean isSimple() {
        return false;
    }

    public ItemStack getExtractedStack(ItemStack input) {
        IFluidHandlerItem handler = (IFluidHandlerItem)input.copyWithCount(1).getCapability(Capabilities.FluidHandler.ITEM);
        if (handler != null) {
            handler.drain(this.fluidIngredient.amount(), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }
        return input.getCraftingRemainingItem();
    }

    public IngredientType<?> getType() {
        return (IngredientType)IEIngredients.FLUID_STACK.value();
    }
}

