/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.upgrade.Cooldown;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.ComponentEnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class IEShieldItem
extends UpgradeableToolItem {
    public static final String TYPE = "SHIELD";

    public IEShieldItem() {
        super(new Item.Properties().durability(1024), TYPE, 2);
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        IEShieldItem.registerCapabilitiesISI(registrar);
        registrar.register(Capabilities.EnergyStorage.ITEM, stack -> new ComponentEnergyStorage((MutableDataComponentHolder)stack, (DataComponentType)IEDataComponents.GENERIC_ENERGY.get(), IEShieldItem.getMaxEnergyStored(stack)));
        registrar.register(CapabilityShader.ITEM, stack -> new CapabilityShader.ShaderWrapper_Item(IEApi.ieLoc("shield"), (ItemStack)stack));
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged || CapabilityShader.shouldReequipDueToShader(oldStack, newStack)) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        if (IEShieldItem.getMaxEnergyStored(stack) > 0) {
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            String stored = energyStorage.getEnergyStored() + "/" + IEShieldItem.getMaxEnergyStored(stack);
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
        }
    }

    public void inventoryTick(ItemStack stack, Level world, Entity ent, int slot, boolean inHand) {
        super.inventoryTick(stack, world, ent, slot, inHand);
        if (world.isClientSide) {
            return;
        }
        if (ent instanceof LivingEntity) {
            inHand |= ((LivingEntity)ent).getItemInHand(InteractionHand.OFF_HAND) == stack;
        }
        boolean blocking = ent instanceof LivingEntity && ((LivingEntity)ent).isBlocking();
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (!inHand || !blocking) {
            for (UpgradeEffect<Cooldown> cooldownKey : List.of(UpgradeEffect.FLASH, UpgradeEffect.SHOCK)) {
                UpgradeData upgrades = this.getUpgrades(stack);
                Cooldown cooldown = upgrades.get(cooldownKey);
                if (!cooldown.isOnCooldown() || energy.extractEnergy(10, true) != 10) continue;
                energy.extractEnergy(10, false);
                if (!cooldown.isOnCooldown()) continue;
                stack.set(IEDataComponents.UPGRADE_DATA, (Object)upgrades.with(cooldownKey, cooldown.tick()));
            }
        }
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        return ItemAbilities.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
    }

    public void hitShield(ItemStack stack, Player player, DamageSource source, float amount, LivingDamageEvent.Pre event) {
        UpgradeData upgrades = this.getUpgrades(stack);
        if (upgrades.has(UpgradeEffect.FLASH) && !upgrades.get(UpgradeEffect.FLASH).isOnCooldown()) {
            Vec3 look = player.getLookAngle();
            List<LivingEntity> targets = Utils.getTargetsInCone(player.getCommandSenderWorld(), player.position().subtract(look), player.getLookAngle().scale(9.0), 1.57079f, 0.5f);
            for (LivingEntity t : targets) {
                if (player.equals((Object)t)) continue;
                t.addEffect(new MobEffectInstance(IEPotions.FLASHED, 100, 1));
                if (!(t instanceof Mob)) continue;
                ((Mob)t).setTarget(null);
            }
            upgrades = upgrades.with(UpgradeEffect.FLASH, new Cooldown(40));
        }
        if (upgrades.has(UpgradeEffect.SHOCK) && !upgrades.get(UpgradeEffect.SHOCK).isOnCooldown()) {
            boolean b = false;
            if (event.getSource().is(DamageTypeTags.IS_PROJECTILE) && event.getSource().getDirectEntity() != null) {
                Entity projectile = event.getSource().getDirectEntity();
                projectile.discard();
                event.setNewDamage(0.0f);
                b = true;
            }
            if (event.getSource().getEntity() != null && event.getSource().getEntity() instanceof LivingEntity && event.getSource().getEntity().distanceToSqr((Entity)player) < 4.0) {
                IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(event.getEntity().level(), 1.0f, true);
                dmgsrc.apply(event.getSource().getEntity());
                b = true;
            }
            if (b) {
                upgrades = upgrades.with(UpgradeEffect.SHOCK, new Cooldown(40));
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)IESounds.spark.value(), SoundSource.BLOCKS, 2.5f, 0.5f + ApiUtils.RANDOM.nextFloat());
            }
        }
        stack.set(IEDataComponents.UPGRADE_DATA, (Object)upgrades);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack material) {
        return material.is(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot);
    }

    public static int getMaxEnergyStored(ItemStack container) {
        UpgradeData upgrades = IEShieldItem.getUpgradesStatic(container);
        return upgrades.has(UpgradeEffect.FLASH) || upgrades.has(UpgradeEffect.SHOCK) ? 3200 : 0;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 72000;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    @Nonnull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 80, 32, TYPE, stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 100, 32, TYPE, stack, true, level, getPlayer)};
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }
}

