/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public abstract class InternalStorageItem
extends IEBaseItem {
    private final int slotCount;

    public InternalStorageItem(Item.Properties props, int slotCount) {
        super(props.component(IEDataComponents.GENERIC_ITEMS, (Object)ItemContainerContents.EMPTY));
        this.slotCount = slotCount;
    }

    public static void registerCapabilitiesISI(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        registrar.register(Capabilities.ItemHandler.ITEM, InternalStorageItem::makeInternalItemHandler);
    }

    public static IItemHandlerModifiable makeInternalItemHandler(ItemStack stack) {
        InternalStorageItem item = (InternalStorageItem)stack.getItem();
        return new ComponentItemHandler((MutableDataComponentHolder)stack, (DataComponentType)IEDataComponents.GENERIC_ITEMS.get(), item.slotCount);
    }

    public void setContainedItems(ItemStack stack, NonNullList<ItemStack> inventory) {
        stack.set(IEDataComponents.GENERIC_ITEMS, (Object)ItemContainerContents.fromItems(inventory));
    }

    public static ItemContainerContents getContainedItems(ItemStack stack) {
        return (ItemContainerContents)stack.getOrDefault(IEDataComponents.GENERIC_ITEMS, (Object)ItemContainerContents.EMPTY);
    }

    public int getSlotCount() {
        return this.slotCount;
    }
}

