/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.SyncedConnection;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageSkyhookSync(SyncedConnection connection, int entityID, ConnectionPoint start, double linePos, double speed) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageSkyhookSync> ID = IMessage.createType("skyhook_sync");
    public static final StreamCodec<ByteBuf, MessageSkyhookSync> CODEC = StreamCodec.composite(SyncedConnection.CODEC, MessageSkyhookSync::connection, (StreamCodec)ByteBufCodecs.INT, MessageSkyhookSync::entityID, (StreamCodec)ConnectionPoint.CODECS.streamCodec(), MessageSkyhookSync::start, (StreamCodec)ByteBufCodecs.DOUBLE, MessageSkyhookSync::linePos, (StreamCodec)ByteBufCodecs.DOUBLE, MessageSkyhookSync::speed, MessageSkyhookSync::new);

    public MessageSkyhookSync(SkylineHookEntity entity) {
        this(new SyncedConnection(entity.getConnection()), entity.getId(), entity.start, entity.linePos, entity.horizontalSpeed);
    }

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity ent;
            Level world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null && (ent = world.getEntity(this.entityID)) instanceof SkylineHookEntity) {
                SkylineHookEntity hook = (SkylineHookEntity)ent;
                hook.setConnectionAndPos(this.connection.toConnection(), this.start, this.linePos, this.speed);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

