/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.SyncedConnection;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.SectionPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageWireSync(SyncedConnection connection, Operation operation) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageWireSync> ID = IMessage.createType("wire_sync");
    public static final StreamCodec<ByteBuf, MessageWireSync> CODEC = StreamCodec.composite(SyncedConnection.CODEC, MessageWireSync::connection, (StreamCodec)ByteBufCodecs.idMapper(i -> Operation.VALUES[i], Enum::ordinal), MessageWireSync::operation, MessageWireSync::new);

    public MessageWireSync(Connection conn, Operation operation) {
        this(new SyncedConnection(conn), operation);
    }

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            ConnectionPoint start = this.connection.start();
            ConnectionPoint end = this.connection.end();
            WireType type = this.connection.type();
            WireLogger.logger.debug("Processing sync for connection from {} to {}, type {}, op {}", (Object)start, (Object)end, (Object)type, (Object)this.operation.name());
            Player player = ImmersiveEngineering.proxy.getClientPlayer();
            Level w = player.level();
            GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(w);
            Connection connection = this.connection.toConnection();
            if (this.operation != Operation.ADD && globalNet.getNullableLocalNet(start) != null && globalNet.getNullableLocalNet(end) != null) {
                globalNet.removeConnection(connection);
                this.removeProxyIfNoWires(start, globalNet);
                this.removeProxyIfNoWires(end, globalNet);
            }
            if (this.operation != Operation.REMOVE) {
                globalNet.addConnection(connection);
            }
            ObjectArraySet sectionsToRerender = new ObjectArraySet();
            WireUtils.forEachRenderPoint(connection, (arg_0, arg_1, arg_2) -> MessageWireSync.lambda$process$1((Set)sectionsToRerender, arg_0, arg_1, arg_2));
            for (SectionPos section : sectionsToRerender) {
                Minecraft.getInstance().levelRenderer.setSectionDirty(section.x(), section.y(), section.z());
            }
        });
    }

    private void removeProxyIfNoWires(ConnectionPoint point, GlobalWireNetwork globalNet) {
        LocalWireNetwork localNet = globalNet.getLocalNet(point);
        IImmersiveConnectable iic = localNet.getConnector(point);
        if (iic.isProxy() && !WireUtils.hasAnyConnections(globalNet, iic)) {
            globalNet.removeConnector(iic);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private static /* synthetic */ void lambda$process$1(Set sectionsToRerender, int $, Vec3 $2, SectionPos section) {
        sectionsToRerender.add(section);
    }

    public static enum Operation {
        ADD,
        REMOVE,
        UPDATE;

        private static final Operation[] VALUES;

        static {
            VALUES = Operation.values();
        }
    }
}

