/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fakeworld;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class TemplateChunkSection
extends LevelChunkSection {
    private final int sectionY;
    private final Predicate<BlockPos> shouldShow;
    private final ChunkPos chunkPos;

    public TemplateChunkSection(int sectionY, Registry<Biome> biomeRegistry, Predicate<BlockPos> shouldShow, ChunkPos chunkPos) {
        super(biomeRegistry);
        this.sectionY = sectionY;
        this.shouldShow = shouldShow;
        this.chunkPos = chunkPos;
    }

    @Nonnull
    public BlockState setBlockState(int x, int y, int z, @Nonnull BlockState state, boolean lock) {
        return this.getBlockState(x, y, z);
    }

    @Nonnull
    public BlockState actuallySetBlockState(int x, int y, int z, @Nonnull BlockState state) {
        return super.setBlockState(x, y, z, state, false);
    }

    public BlockState getBlockState(int x, int y, int z) {
        if (!this.shouldShow.test(new BlockPos(this.chunkPos.getMinBlockX() + x, 16 * this.sectionY + y, this.chunkPos.getMinBlockZ() + z))) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.getBlockState(x, y, z);
    }
}

