/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RevolverperkLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<RevolverperkLootFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> RevolverperkLootFunction.commonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, RevolverperkLootFunction::new));

    protected RevolverperkLootFunction(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public ItemStack run(ItemStack stack, @Nonnull LootContext context) {
        RevolverItem.Perks perks = RevolverItem.RevolverPerk.generatePerkSet(context.getRandom(), context.getLuck());
        stack.set(IEDataComponents.REVOLVER_PERKS, (Object)perks);
        return stack;
    }

    @Nonnull
    public LootItemFunctionType getType() {
        return (LootItemFunctionType)IELootFunctions.REVOLVERPERK.value();
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(RevolverperkLootFunction::new);
    }
}

