/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block;

import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotationHandler;
import com.hrznstudio.titanium.block.tile.BasicTile;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class RotatableBlock<T extends BasicTile<T>>
extends BasicTileBlock<T> {
    public static final DirectionProperty FACING_ALL = DirectionProperty.create((String)"facing", (Direction[])Direction.values());
    public static final DirectionProperty FACING_HORIZONTAL = DirectionProperty.create((String)"subfacing", (Predicate)Direction.Plane.HORIZONTAL);

    public RotatableBlock(String name, BlockBehaviour.Properties properties, Class<T> tileClass) {
        super(properties, tileClass);
    }

    @Nonnull
    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_196258_1_) {
        return this.getRotationType().getHandler().getStateForPlacement(this, p_196258_1_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.createBlockStateDefinition(p_206840_1_);
        if (this.getRotationType().getProperties() != null) {
            p_206840_1_.add((Property[])this.getRotationType().getProperties());
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (this.getRotationType().getProperties().length > 0) {
            return (BlockState)state.setValue((Property)this.getRotationType().getProperties()[0], (Comparable)rot.rotate((Direction)state.getValue((Property)this.getRotationType().getProperties()[0])));
        }
        return super.rotate(state, rot);
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        if (this.getRotationType().getProperties().length > 0) {
            return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)this.getRotationType().getProperties()[0])));
        }
        return super.mirror(state, mirrorIn);
    }

    public static enum RotationType {
        NONE((block, context) -> block.defaultBlockState(), new DirectionProperty[0]),
        FOUR_WAY((block, context) -> (BlockState)block.defaultBlockState().setValue((Property)FACING_HORIZONTAL, (Comparable)context.getHorizontalDirection().getOpposite()), FACING_HORIZONTAL),
        SIX_WAY((block, context) -> (BlockState)block.defaultBlockState().setValue((Property)FACING_ALL, (Comparable)context.getNearestLookingDirection().getOpposite()), FACING_ALL),
        TWENTY_FOUR_WAY((block, context) -> (BlockState)block.defaultBlockState().setValue((Property)FACING_ALL, (Comparable)context.getNearestLookingDirection()), FACING_ALL, FACING_HORIZONTAL);

        private final RotationHandler handler;
        private final DirectionProperty[] properties;

        private RotationType(RotationHandler handler, DirectionProperty ... properties) {
            this.handler = handler;
            this.properties = properties;
        }

        public RotationHandler getHandler() {
            return this.handler;
        }

        public DirectionProperty[] getProperties() {
            return this.properties;
        }
    }
}

