/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.datagenerator.loot.block;

import com.hrznstudio.titanium.datagenerator.loot.block.IBlockLootTableProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class BasicBlockLootTables
extends BlockLootSubProvider {
    private final Supplier<List<Block>> blocksToProcess;

    public BasicBlockLootTables(Supplier<List<Block>> blocksToProcess, HolderLookup.Provider provider) {
        super(new HashSet(), FeatureFlags.REGISTRY.allFlags(), provider);
        this.blocksToProcess = blocksToProcess;
    }

    public LootTable.Builder droppingNothing() {
        return LootTable.lootTable();
    }

    public LootTable.Builder droppingSelf(ItemLike itemProvider) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition(itemProvider, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)itemProvider))));
    }

    protected void generate() {
        this.blocksToProcess.get().forEach(block -> {
            if (block instanceof IBlockLootTableProvider) {
                this.add((Block)block, ((IBlockLootTableProvider)block).getLootTable(this));
            }
        });
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> p_249322_) {
        this.generate();
        HashSet<ResourceKey> set = new HashSet<ResourceKey>();
        for (Block block : this.getKnownBlocks()) {
            ResourceKey resourcelocation;
            if (!block.isEnabled(this.enabledFeatures) || (resourcelocation = block.getLootTable()) == BuiltInLootTables.EMPTY || !set.add(resourcelocation)) continue;
            LootTable.Builder loottable$builder = (LootTable.Builder)this.map.remove(resourcelocation);
            if (loottable$builder == null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourcelocation, BuiltInRegistries.BLOCK.getKey((Object)block)));
            }
            p_249322_.accept((ResourceKey<LootTable>)resourcelocation, loottable$builder);
        }
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.blocksToProcess.get();
    }
}

