/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.items;

import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.EnergyData;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.init.ItemData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class EnergyModuleItem
extends ModuleItem<EnergyData> {
    public EnergyModuleItem(Item.Properties properties, Supplier<Module<?>> moduleSupplier) {
        super(properties, moduleSupplier);
    }

    public EnergyModuleItem(Supplier<Module<?>> moduleSupplier) {
        super(moduleSupplier);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        long energy = (Long)stack.getOrDefault(ItemData.ENERGY_MODULE_ENERGY, (Object)0L);
        if (energy > 0L) {
            tooltip.add((Component)Component.translatable((String)"module.draconicevolution.energy.stored_energy").append(": ").append(Utils.formatNumber((long)energy)).append(" ").append((Component)Component.translatable((String)("op.brandonscore." + (Screen.hasShiftDown() ? "operational_potential" : "op")))).withStyle(ChatFormatting.GRAY));
        }
    }
}

