/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.lib.CustomTabHandling;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEDamage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChaosCrystal
extends EntityBlockBCore
implements CustomTabHandling {
    private static VoxelShape SHAPE = Shapes.box((double)0.0, (double)-2.0, (double)0.0, (double)1.0, (double)3.0, (double)1.0);

    public ChaosCrystal(BlockBehaviour.Properties properties) {
        super(properties);
        this.setBlockEntity(() -> DEContent.TILE_CHAOS_CRYSTAL.get(), true);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        TileChaosCrystal tile;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileChaosCrystal && !(tile = (TileChaosCrystal)blockEntity).attemptingBreak(player)) {
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        TileChaosCrystal tile;
        TileChaosCrystal tileChaosCrystal = tile = world.getBlockEntity(pos) instanceof TileChaosCrystal ? (TileChaosCrystal)world.getBlockEntity(pos) : null;
        if (tile != null) {
            return tile.attemptingBreak(null) ? super.getDestroyProgress(state, player, world, pos) : -1.0f;
        }
        return -1.0f;
    }

    public void wasExploded(Level worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (!world.isClientSide && tile instanceof TileChaosCrystal) {
            ((TileChaosCrystal)tile).detonate(null);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player && ((Player)placer).getAbilities().instabuild) {
            BlockEntity tile = level.getBlockEntity(pos);
            if (!level.isClientSide && tile instanceof TileChaosCrystal) {
                ((TileChaosCrystal)tile).onValidPlacement();
                ((TileChaosCrystal)tile).guardianDefeated.set(true);
            }
        } else {
            placer.hurt(DEDamage.chaosImplosion(level), Float.MAX_VALUE);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.is((Block)DEContent.CHAOS_CRYSTAL.get())) {
            return SHAPE;
        }
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileChaosCrystal) {
            TileChaosCrystal crystal = (TileChaosCrystal)tile;
            BlockPos parentPos = crystal.parentPos.get();
            if (parentPos == null) {
                return SHAPE;
            }
            BlockPos offset = parentPos.subtract((Vec3i)pos);
            return SHAPE.move(0.0, (double)offset.getY(), 0.0);
        }
        return SHAPE;
    }
}

