/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.hud.IHudBlock;
import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingInjector;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;

public class CraftingInjector
extends EntityBlockBCore
implements IHudBlock {
    public static final UUID MSG_ID = UUID.fromString("3b0a968f-b0f6-4969-b00f-a49a2a36d40b");
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static VoxelShape SHAPE_DOWN = Shapes.box((double)0.0625, (double)0.375, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
    private static VoxelShape SHAPE_UP = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.625, (double)0.9375);
    private static VoxelShape SHAPE_NORTH = Shapes.box((double)0.0625, (double)0.0625, (double)0.375, (double)0.9375, (double)0.9375, (double)1.0);
    private static VoxelShape SHAPE_SOUTH = Shapes.box((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.625);
    private static VoxelShape SHAPE_WEST = Shapes.box((double)0.375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375);
    private static VoxelShape SHAPE_EAST = Shapes.box((double)0.0, (double)0.0625, (double)0.0625, (double)0.625, (double)0.9375, (double)0.9375);
    private final TechLevel techLevel;

    public CraftingInjector(BlockBehaviour.Properties properties, TechLevel techLevel) {
        super(properties);
        this.techLevel = techLevel;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
        this.setBlockEntity(() -> DEContent.TILE_CRAFTING_INJECTOR.get(), false);
    }

    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public void destroy(LevelAccessor p_176206_1_, BlockPos p_176206_2_, BlockState p_176206_3_) {
        super.destroy(p_176206_1_, p_176206_2_, p_176206_3_);
    }

    public void onRemove(BlockState p_196243_1_, Level world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileFusionCraftingInjector) {
            ((TileFusionCraftingInjector)tile).onDestroyed();
        }
        super.onRemove(p_196243_1_, world, pos, p_196243_4_, p_196243_5_);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = level.getBlockEntity(pos);
        if (!(tile instanceof TileFusionCraftingInjector)) {
            return InteractionResult.FAIL;
        }
        TileFusionCraftingInjector craftingPedestal = (TileFusionCraftingInjector)tile;
        if (player.isShiftKeyDown()) {
            craftingPedestal.singleItem.set(!craftingPedestal.singleItem.get());
            ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)("fusion_inj.draconicevolution." + (craftingPedestal.singleItem.get() ? "single_item" : "multi_item"))), (UUID)MSG_ID);
            craftingPedestal.getDataManager().detectAndSendChanges();
            return InteractionResult.SUCCESS;
        }
        if (!craftingPedestal.itemHandler.getStackInSlot(0).isEmpty()) {
            if (player.getMainHandItem().isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, craftingPedestal.itemHandler.getStackInSlot(0));
                craftingPedestal.setInjectorStack(ItemStack.EMPTY);
            } else {
                level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), craftingPedestal.itemHandler.getStackInSlot(0)));
                craftingPedestal.setInjectorStack(ItemStack.EMPTY);
            }
        } else {
            ItemStack stack = player.getMainHandItem();
            player.setItemInHand(InteractionHand.MAIN_HAND, InventoryUtils.insertItem((IItemHandler)craftingPedestal.itemHandler, (ItemStack)stack, (boolean)false));
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        switch (facing) {
            case DOWN: {
                return SHAPE_DOWN;
            }
            case UP: {
                return SHAPE_UP;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: {
                return SHAPE_EAST;
            }
        }
        return super.getShape(state, worldIn, pos, context);
    }

    public void generateHudText(Level world, BlockPos pos, Player player, List<Component> displayList) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TileFusionCraftingInjector) {
            boolean single = ((TileFusionCraftingInjector)te).singleItem.get();
            displayList.add((Component)Component.translatable((String)("fusion_inj.draconicevolution." + (single ? "single_item" : "multi_item"))).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
        }
    }
}

