/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class TileCreativeOPCapacitor
extends TileBCore
implements IInteractTile {
    private static final UUID MSG_UUID = UUID.fromString("813497f2-6161-4767-ade5-ee607bec1425");
    private final ManagedLong powerRate = (ManagedLong)this.register((IManagedData)new ManagedLong("power_rate", 1000000000L, new DataFlags[]{DataFlags.SAVE_NBT}));

    public TileCreativeOPCapacitor(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_CREATIVE_OP_CAPACITOR.get(), pos, state);
        this.capManager.set(CapabilityOP.BLOCK, (Object)new IOPStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return (int)Math.min((long)maxReceive, TileCreativeOPCapacitor.this.powerRate.get());
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return (int)Math.min((long)maxExtract, TileCreativeOPCapacitor.this.powerRate.get());
            }

            public int getEnergyStored() {
                return 0x3FFFFFFF;
            }

            public int getMaxEnergyStored() {
                return Integer.MAX_VALUE;
            }

            public long modifyEnergyStored(long amount) {
                return amount;
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return true;
            }

            public long getOPStored() {
                return 0x3FFFFFFFFFFFFFFFL;
            }

            public long getMaxOPStored() {
                return Long.MAX_VALUE;
            }

            public long receiveOP(long maxReceive, boolean simulate) {
                return Math.min(maxReceive, TileCreativeOPCapacitor.this.powerRate.get());
            }

            public long extractOP(long maxExtract, boolean simulate) {
                return Math.min(maxExtract, TileCreativeOPCapacitor.this.powerRate.get());
            }
        }, new Direction[0]);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileCreativeOPCapacitor.energyCapability((RegisterCapabilitiesEvent)event, DEContent.TILE_CREATIVE_OP_CAPACITOR);
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            for (Direction direction : Direction.values()) {
                TileCreativeOPCapacitor.sendEnergyTo((LevelReader)this.level, (BlockPos)this.worldPosition, (long)this.powerRate.get(), (Direction)direction);
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Player player, BlockHitResult hit) {
        if (!this.level.isClientSide) {
            if (player.isShiftKeyDown()) {
                this.powerRate.divide(10L);
            } else if (this.powerRate.get() == Long.MAX_VALUE) {
                this.powerRate.set(1L);
            } else {
                this.powerRate.multiply(10L);
            }
            if (this.powerRate.get() < 1L) {
                this.powerRate.set(Long.MAX_VALUE);
            }
            BrandonsCore.proxy.sendIndexedMessage(player, (Component)Component.literal((String)("Power Rate: " + Utils.addCommas((long)this.powerRate.get()) + " OP/t")), MSG_UUID);
        }
        return InteractionResult.SUCCESS;
    }
}

