/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRedstoneEmitter;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.draconicevolution.blocks.Potentiometer;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TilePotentiometer
extends TileBCore
implements IRedstoneEmitter,
IInteractTile {
    public static final UUID MSG_ID = UUID.fromString("8a45fb40-4316-4e4f-b435-867f44960966");
    public final ManagedEnum<Direction> rotation = (ManagedEnum)this.register((IManagedData)new ManagedEnum("rotation", (Enum)Direction.NORTH, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte power = (ManagedByte)this.register((IManagedData)new ManagedByte("power", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));

    public TilePotentiometer(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_POTENTIOMETER.get(), pos, state);
    }

    public Direction getRotation() {
        return (Direction)this.rotation.get();
    }

    public void setRotation(Direction rotation) {
        this.rotation.set((Enum)rotation);
        super.tick();
    }

    public int getWeakPower(BlockState blockState, Direction side) {
        return this.power.get();
    }

    public int getStrongPower(BlockState blockState, Direction side) {
        return this.power.get();
    }

    public InteractionResult useWithoutItem(BlockState state, Player player, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            this.power.dec();
            if (this.power.get() < 0) {
                this.power.set(15);
            }
        } else {
            this.power.inc();
            if (this.power.get() > 15) {
                this.power.zero();
            }
        }
        if (this.level.isClientSide) {
            ChatHelper.sendIndexed((Player)player, (Component)Component.literal((String)String.valueOf(this.power.get())), (UUID)MSG_ID);
        } else {
            this.level.playSound(null, this.worldPosition, SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.3f, 0.8f + (float)this.power.get() / 15.0f);
        }
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        this.level.updateNeighborsAt(this.worldPosition.relative(((Direction)this.getBlockState().getValue((Property)Potentiometer.FACING)).getOpposite()), this.getBlockState().getBlock());
        super.tick();
        return InteractionResult.SUCCESS;
    }
}

