/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import codechicken.lib.render.shader.CCShaderInstance;
import codechicken.lib.render.shader.CCUniform;
import codechicken.lib.util.ClientUtils;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.draconicevolution.client.shader.ShieldShader;
import com.brandon3055.draconicevolution.client.shader.ToolShader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;

public class DEShaders {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    public static CCShaderInstance reactorShader;
    public static CCUniform reactorTime;
    public static CCUniform reactorIntensity;
    public static CCShaderInstance reactorShieldShader;
    public static CCUniform reactorShieldTime;
    public static CCUniform reactorShieldIntensity;
    public static CCShaderInstance chaosBlockShader;
    public static CCUniform chaosBlockTime;
    public static CCUniform chaosBlockYaw;
    public static CCUniform chaosBlockPitch;
    public static CCUniform chaosBlockAlpha;
    public static final ToolShader TOOL_BASE_SHADER;
    public static final ToolShader TOOL_GEM_SHADER;
    public static final ToolShader TOOL_TRACE_SHADER;
    public static final ToolShader TOOL_BLADE_SHADER;
    public static final ToolShader BOW_STRING_SHADER;
    public static final ToolShader CHESTPIECE_GEM_SHADER;
    public static final ShieldShader CHESTPIECE_SHIELD_SHADER;
    public static CCShaderInstance shieldShader;
    public static CCUniform shieldTime;
    public static CCUniform shieldActivation;
    public static CCUniform shieldColour;
    public static CCUniform shieldBarMode;
    public static CCShaderInstance energyCrystalShader;
    public static CCUniform energyCrystalTime;
    public static CCUniform energyCrystalColour;
    public static CCUniform energyCrystalMipmap;
    public static CCUniform energyCrystalAngle;
    public static CCShaderInstance energyCoreShader;
    public static CCUniform energyCoreTime;
    public static CCUniform energyCoreActivation;
    public static CCUniform energyCoreEffectColour;
    public static CCUniform energyCoreFrameColour;
    public static CCUniform energyCoreRotTriColour;
    public static CCShaderInstance reactorBeamShader;
    public static CCUniform reactorBeamTime;
    public static CCUniform reactorBeamFade;
    public static CCUniform reactorBeamPower;
    public static CCUniform reactorBeamStartup;
    public static CCUniform reactorBeamType;
    public static CCShaderInstance explosionFlashShader;
    public static CCUniform explosionFlashScreenPos;
    public static CCUniform explosionFlashScreenSize;
    public static CCUniform explosionFlashIntensity;
    public static CCShaderInstance explosionShader;
    public static CCUniform explosionTime;
    public static CCUniform explosionScale;
    public static CCUniform explosionAlpha;
    public static CCUniform explosionType;

    public static void init(IEventBus modBus) {
        LOCK.lock();
        TOOL_BASE_SHADER.register(modBus);
        TOOL_GEM_SHADER.register(modBus);
        TOOL_TRACE_SHADER.register(modBus);
        TOOL_BLADE_SHADER.register(modBus);
        BOW_STRING_SHADER.register(modBus);
        CHESTPIECE_GEM_SHADER.register(modBus);
        CHESTPIECE_SHIELD_SHADER.register(modBus);
        modBus.addListener(DEShaders::onRegisterShaders);
    }

    private static void onRegisterShaders(RegisterShadersEvent event) {
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"reactor"), (VertexFormat)DefaultVertexFormat.POSITION_TEX), e -> {
            reactorShader = (CCShaderInstance)e;
            reactorTime = reactorShader.getUniform("time");
            reactorIntensity = reactorShader.getUniform("intensity");
        });
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"reactor_shield"), (VertexFormat)DefaultVertexFormat.POSITION_TEX), e -> {
            reactorShieldShader = (CCShaderInstance)e;
            reactorShieldTime = reactorShieldShader.getUniform("time");
            reactorShieldIntensity = reactorShieldShader.getUniform("intensity");
        });
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"chaos_block"), (VertexFormat)DefaultVertexFormat.BLOCK), e -> {
            chaosBlockShader = (CCShaderInstance)e;
            chaosBlockTime = chaosBlockShader.getUniform("Time");
            chaosBlockYaw = chaosBlockShader.getUniform("Yaw");
            chaosBlockPitch = chaosBlockShader.getUniform("Pitch");
            chaosBlockAlpha = chaosBlockShader.getUniform("Alpha");
        });
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"shield"), (VertexFormat)DefaultVertexFormat.POSITION_TEX), e -> {
            shieldShader = (CCShaderInstance)e;
            shieldTime = shieldShader.getUniform("Time");
            shieldActivation = shieldShader.getUniform("Activation");
            shieldColour = shieldShader.getUniform("BaseColour");
            shieldBarMode = shieldShader.getUniform("BarMode");
            shieldShader.onApply(() -> shieldTime.glUniform1f(((float)TimeKeeper.getClientTick() + RenderUtils.partialTick()) / 20.0f));
        });
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"energy_crystal"), (VertexFormat)DefaultVertexFormat.POSITION_TEX), e -> {
            energyCrystalShader = (CCShaderInstance)e;
            energyCrystalTime = energyCrystalShader.getUniform("Time");
            energyCrystalColour = energyCrystalShader.getUniform("Colour");
            energyCrystalMipmap = energyCrystalShader.getUniform("Mipmap");
            energyCrystalAngle = energyCrystalShader.getUniform("Angle");
            energyCrystalShader.onApply(() -> energyCrystalTime.glUniform1f(((float)TimeKeeper.getClientTick() + RenderUtils.partialTick()) / 50.0f));
        });
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"energy_core"), (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP), e -> {
            energyCoreShader = (CCShaderInstance)e;
            energyCoreTime = energyCoreShader.getUniform("Time");
            energyCoreActivation = energyCoreShader.getUniform("Activation");
            energyCoreEffectColour = energyCoreShader.getUniform("EffectColour");
            energyCoreFrameColour = energyCoreShader.getUniform("FrameColour");
            energyCoreRotTriColour = energyCoreShader.getUniform("InnerTriColour");
            energyCoreShader.onApply(() -> energyCoreTime.glUniform1f(((float)TimeKeeper.getClientTick() + RenderUtils.partialTick()) / 20.0f));
        });
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"reactor_beam"), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR), e -> {
            reactorBeamShader = (CCShaderInstance)e;
            reactorBeamTime = reactorBeamShader.getUniform("Time");
            reactorBeamFade = reactorBeamShader.getUniform("Fade");
            reactorBeamPower = reactorBeamShader.getUniform("Power");
            reactorBeamStartup = reactorBeamShader.getUniform("Startup");
            reactorBeamType = reactorBeamShader.getUniform("Type");
            reactorBeamShader.onApply(() -> reactorBeamTime.glUniform1f(((float)TimeKeeper.getClientTick() + RenderUtils.partialTick()) * 0.02f));
        });
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"explosion_flash"), (VertexFormat)DefaultVertexFormat.POSITION_COLOR), e -> {
            explosionFlashShader = (CCShaderInstance)e;
            explosionFlashScreenPos = explosionFlashShader.getUniform("ScreenPos");
            explosionFlashScreenSize = explosionFlashShader.getUniform("ScreenSize");
            explosionFlashIntensity = explosionFlashShader.getUniform("Intensity");
        });
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"explosion"), (VertexFormat)DefaultVertexFormat.POSITION_TEX), e -> {
            explosionShader = (CCShaderInstance)e;
            explosionTime = explosionShader.getUniform("Time");
            explosionScale = explosionShader.getUniform("Scale");
            explosionAlpha = explosionShader.getUniform("Alpha");
            explosionType = explosionShader.getUniform("Type");
        });
    }

    static {
        TOOL_BASE_SHADER = new ToolShader("tools/tool_base", DefaultVertexFormat.NEW_ENTITY);
        TOOL_GEM_SHADER = (ToolShader)new ToolShader("tools/tool_gem", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
        TOOL_TRACE_SHADER = (ToolShader)new ToolShader("tools/tool_trace", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
        TOOL_BLADE_SHADER = (ToolShader)new ToolShader("tools/tool_blade", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
        BOW_STRING_SHADER = (ToolShader)new ToolShader("tools/bow_string", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
        CHESTPIECE_GEM_SHADER = (ToolShader)new ToolShader("tools/chestpiece_gem", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
        CHESTPIECE_SHIELD_SHADER = (ShieldShader)new ShieldShader("tools/chestpiece_shield", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
    }
}

