/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.machines.Grinder;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGrinder;
import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RenderTileGrinder
implements BlockEntityRenderer<TileGrinder> {
    private static final double[] ROTATION_MAP = new double[]{0.0, 180.0, 90.0, -90.0};
    private static final RenderType swordType = RenderType.entitySolid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"textures/block/grinder.png"));
    private static final RenderType fanType = RenderType.entitySolid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"textures/block/parts/machine_fan.png"));
    private static final RenderType aoeOutlineType = RenderType.create((String)"aoe", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setWriteMaskState(RenderStateShard.COLOR_WRITE).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(4.0))).createCompositeState(false));
    private static RenderType aoeSolidType = RenderType.create((String)"aoe_solid", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorShader)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));
    private final CCModel swordModel;
    private final CCModel fanModel;

    public RenderTileGrinder(BlockEntityRendererProvider.Context context) {
        Map map = new OBJParser(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"models/block/grinder/grinder_fan.obj")).quads().ignoreMtl().parse();
        this.fanModel = CCModel.combine(map.values());
        map = new OBJParser(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"models/block/grinder/grinder_sword.obj")).quads().ignoreMtl().parse();
        this.swordModel = CCModel.combine(map.values());
        this.swordModel.computeNormals();
        this.swordModel.apply((Transformation)new Scale(-0.0625));
        this.swordModel.apply((Transformation)new Rotation(3.1415926535897403, 0.0, 0.0, 1.0));
        this.swordModel.apply((Transformation)new Rotation(1.5707963267948701, 0.0, 1.0, 0.0));
    }

    public void render(TileGrinder tile, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        BlockState state = tile.getLevel().getBlockState(tile.getBlockPos());
        if (!state.is((Block)DEContent.GRINDER.get())) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)Grinder.FACING);
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind(swordType, getter);
        ccrs.r = new TransformingVertexConsumer(ccrs.r, (Transformation)mat);
        Vector3 tilePos = Vector3.fromTileCenter((BlockEntity)tile);
        Vector3 vecA = tile.targetA == null ? null : this.getEntityMovingVec(tile.targetA, partialTicks);
        Vector3 vecB = tile.targetB == null ? null : this.getEntityMovingVec(tile.targetB, partialTicks);
        this.renderSword(ccrs, facing, 0.34, tilePos, vecA, Math.min(tile.animA + partialTicks * tile.getAnimSpeed(), 1.0f), partialTicks);
        this.renderSword(ccrs, facing, -0.34, tilePos, vecB, Math.min(tile.animB + partialTicks * tile.getAnimSpeed(), 1.0f), partialTicks);
        ccrs.bind(fanType, getter);
        Matrix4 fanMat = mat.copy();
        fanMat.translate(Vector3.CENTER);
        fanMat.apply((Transformation)new Rotation((double)facing.toYRot() * -0.017453292519943, 0.0, 1.0, 0.0));
        fanMat.apply((Transformation)new Scale(-0.0625));
        fanMat.apply((Transformation)new Rotation((double)(tile.fanRotation + tile.fanSpeed * partialTicks), 0.0, 0.0, 1.0));
        this.fanModel.render(ccrs, new IVertexOperation[]{fanMat});
        if ((double)tile.aoeDisplay > 0.51) {
            tile.validateKillZone(true);
            TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.getBuffer(aoeOutlineType), (Transformation)mat);
            Cuboid6 box = new Cuboid6(tile.killZone.move(Vector3.fromTile((BlockEntity)tile).multiply(-1.0).pos()).deflate(0.01).deflate((double)((float)tile.aoe.get() - tile.aoeDisplay)));
            RenderUtils.bufferCuboidOutline((VertexConsumer)builder, (Cuboid6)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            builder = new TransformingVertexConsumer(getter.getBuffer(aoeSolidType), (Transformation)mat);
            RenderUtils.bufferCuboidSolid((VertexConsumer)builder, (Cuboid6)box, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            com.brandon3055.brandonscore.client.render.RenderUtils.endBatch((MultiBufferSource)getter);
        }
    }

    private void renderSword(CCRenderState ccrs, Direction tileFacing, double sideOffset, Vector3 tilePos, Vector3 targetPos, double attackAnimTime, float partialTicks) {
        double yoyo = (attackAnimTime *= 2.0) > 1.0 ? 1.0 - (attackAnimTime - 1.0) : attackAnimTime;
        double sideAngle = ROTATION_MAP[tileFacing.get3DDataValue() - 2] * 0.017453292519943;
        Transformation rotation = new Rotation(yoyo * Math.PI * -2.8, 1.0, 0.0, 0.0).at(new Vector3(0.0, -0.2, 0.0));
        Vector3 handPos = new Vector3(0.4975 + (sideOffset *= 1.0 - yoyo), 0.5, 0.125 + yoyo * 0.375);
        handPos.apply(new Rotation(sideAngle, 0.0, 1.0, 0.0).at(new Vector3(0.5, 0.0, 0.5)));
        Translation translation = new Translation(handPos);
        TransformationList transforms = rotation.with((Transformation)translation);
        if (targetPos == null) {
            transforms = transforms.with(new Rotation(sideAngle, 0.0, 1.0, 0.0).at(handPos));
        } else {
            Vector3 targetVec = targetPos.copy().subtract(tilePos);
            double angle = Math.atan2(targetVec.x, targetVec.z) + Math.PI;
            transforms = transforms.with(new Rotation(angle, 0.0, 1.0, 0.0).at(handPos));
            transforms = transforms.with((Transformation)new Translation(targetVec.multiply(yoyo)));
        }
        this.swordModel.render(ccrs, new IVertexOperation[]{transforms});
    }

    private Vector3 getEntityMovingVec(Entity entity, float partialTicks) {
        return new Vector3(entity.getPosition(partialTicks)).add(0.0, (double)entity.getBbHeight() / 2.0, 0.0);
    }

    public AABB getRenderBoundingBox(TileGrinder blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(8.0);
    }
}

