/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class DislocatorSaveData
extends SavedData {
    private static final String FILE_NAME = "draconic_dislocator_data";
    private Map<UUID, Map<UUID, DislocatorTarget>> linkTargetMap = new HashMap<UUID, Map<UUID, DislocatorTarget>>();

    @Nullable
    public static DislocatorTarget getLinkTarget(Level world, ItemStack stack) {
        UUID linkID;
        DislocatorSaveData saveData;
        if (BoundDislocator.isValid(stack) && (saveData = DislocatorSaveData.getInstance(world)) != null && saveData.linkTargetMap.containsKey(linkID = BoundDislocator.getLinkId(stack))) {
            Map<UUID, DislocatorTarget> targetMap = saveData.linkTargetMap.get(linkID);
            UUID targetID = BoundDislocator.getDislocatorId(stack);
            for (Map.Entry<UUID, DislocatorTarget> entry : targetMap.entrySet()) {
                UUID entryID = entry.getKey();
                if (entryID.equals(targetID)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public static void updateLinkTarget(Level world, ItemStack stack, DislocatorTarget target) {
        DislocatorSaveData saveData;
        if (BoundDislocator.isValid(stack) && (saveData = DislocatorSaveData.getInstance(world)) != null) {
            UUID linkID = BoundDislocator.getLinkId(stack);
            UUID targetID = BoundDislocator.getDislocatorId(stack);
            saveData.linkTargetMap.computeIfAbsent(linkID, uuid -> new HashMap()).put(targetID, target);
            saveData.setDirty();
        }
    }

    @Nullable
    public static DislocatorSaveData getInstance(Level world) {
        ServerLevel level;
        if (world instanceof ServerLevel && world.getServer() != null && (level = world.getServer().getLevel(Level.OVERWORLD)) != null) {
            return (DislocatorSaveData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(DislocatorSaveData::new, DislocatorSaveData::load), FILE_NAME);
        }
        return null;
    }

    public static DislocatorSaveData load(CompoundTag nbt, HolderLookup.Provider provider) {
        DislocatorSaveData data = new DislocatorSaveData();
        ListTag linkList = nbt.getList("link_map", 10);
        for (Tag lnbt : linkList) {
            CompoundTag linkNBT = (CompoundTag)lnbt;
            UUID linkID = linkNBT.getUUID("link_id");
            ListTag targetList = linkNBT.getList("targets", 10);
            Map targetMap = data.linkTargetMap.computeIfAbsent(linkID, uuid -> new HashMap());
            for (Tag tnbt : targetList) {
                CompoundTag targetNBT = (CompoundTag)tnbt;
                UUID targetID = targetNBT.getUUID("target_id");
                DislocatorTarget target = DislocatorTarget.load(targetNBT);
                targetMap.put(targetID, target);
            }
        }
        return data;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag linkList = new ListTag();
        for (UUID linkID : this.linkTargetMap.keySet()) {
            Map<UUID, DislocatorTarget> targetMap = this.linkTargetMap.get(linkID);
            CompoundTag linkNBT = new CompoundTag();
            linkNBT.putUUID("link_id", linkID);
            ListTag targetList = new ListTag();
            for (UUID targetID : targetMap.keySet()) {
                DislocatorTarget target = targetMap.get(targetID);
                CompoundTag targetNBT = new CompoundTag();
                targetNBT.putUUID("target_id", targetID);
                target.save(targetNBT);
                targetList.add((Object)targetNBT);
            }
            linkNBT.put("targets", (Tag)targetList);
            linkList.add((Object)linkNBT);
        }
        nbt.put("link_map", (Tag)linkList);
        return nbt;
    }
}

