/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PlayerTarget
extends DislocatorTarget {
    private UUID playerID;

    public PlayerTarget(Player player) {
        super((ResourceKey<Level>)player.level().dimension());
        this.playerID = player.getUUID();
    }

    public PlayerTarget(ResourceKey<Level> world) {
        super(world);
    }

    @Override
    public TargetPos getTargetPos(MinecraftServer server, UUID linkID, UUID sourceDislocatorID) {
        ServerPlayer player = server.getPlayerList().getPlayer(this.playerID);
        if (player != null) {
            for (ItemStack stack : player.getInventory().items) {
                if (!BoundDislocator.isValid(stack) || sourceDislocatorID.equals(BoundDislocator.getDislocatorId(stack))) continue;
                return TargetPos.of((Entity)player);
            }
        }
        return null;
    }

    @Override
    protected ServerLevel getTargetWorld(MinecraftServer server) {
        ServerPlayer player = server.getPlayerList().getPlayer(this.playerID);
        if (player != null) {
            return (ServerLevel)player.level();
        }
        return super.getTargetWorld(server);
    }

    @Override
    public CompoundTag save(CompoundTag nbt) {
        nbt.putUUID("player_id", this.playerID);
        return super.save(nbt);
    }

    @Override
    protected void loadInternal(CompoundTag nbt) {
        super.loadInternal(nbt);
        this.playerID = nbt.getUUID("player_id");
    }

    @Override
    public DislocatorTarget.TargetType getType() {
        return DislocatorTarget.TargetType.PLAYER;
    }
}

