/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.ElytraEnabledItem;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.FlightEntity;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.brandon3055.draconicevolution.network.InputSync;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public interface IModularArmor
extends IModularItem,
ElytraEnabledItem {
    @Override
    default public void addModularItemInformation(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        IModularItem.super.addModularItemInformation(stack, context, tooltip, flagIn);
        if (DEConfig.armorSpeedLimit != -1.0 && stack.getCapability(DECapabilities.Host.ITEM) != null && context.level() != null) {
            ModuleHost host = DECapabilities.getHost(stack);
            if (!1.$assertionsDisabled && host == null) {
                throw new AssertionError();
            }
            SpeedData speed = host.getModuleData(ModuleTypes.SPEED);
            if (speed != null && speed.speedMultiplier() > DEConfig.armorSpeedLimit) {
                tooltip.add((Component)Component.literal((String)("Speed limit on this server is +" + (int)(DEConfig.armorSpeedLimit * 100.0) + "%")).withStyle(ChatFormatting.RED));
            }
        }
    }

    default public boolean canElytraFlyBC(ItemStack stack, LivingEntity entity) {
        ModuleHost host = DECapabilities.getHost(stack);
        if (!1.$assertionsDisabled && host == null) {
            throw new AssertionError();
        }
        FlightEntity flight = host.getEntitiesByType(ModuleTypes.FLIGHT).map(e -> (FlightEntity)e).findAny().orElse(null);
        return flight != null && flight.getElytraEnabled();
    }

    /*
     * Unable to fully structure code
     */
    default public boolean elytraFlightTickBC(ItemStack stack, LivingEntity entity, int flightTicks) {
        storage = (IOPStorage)stack.getCapability(CapabilityOP.ITEM);
        if (!(entity instanceof Player)) ** GOTO lbl-1000
        player = (Player)entity;
        if (player.getAbilities().instabuild) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = creative = false;
        }
        if (storage != null) {
            energy = EquipCfg.elytraFlightEnergy;
            if (storage.getOPStored() < (long)energy && !creative) {
                storage.modifyEnergyStored(-10L);
                motion = entity.getDeltaMovement();
                entity.setDeltaMovement(motion.x * 0.95, motion.y > 0.0 ? motion.y * 0.95 : motion.y, motion.z * 0.95);
            } else {
                if (InputSync.getSprintState(entity.getUUID()).booleanValue()) {
                    host = DECapabilities.getHost(stack);
                    try {
                        if (!1.$assertionsDisabled && host == null) {
                            throw new AssertionError();
                        }
                        module = host.getEntitiesByType(ModuleTypes.FLIGHT).findAny().orElse(null);
                        v1 = flightSpeed = module == null ? 0.0 : module.getElytraBoost();
                        if (flightSpeed > 0.0) {
                            speed = 1.5 * flightSpeed;
                            accel = 0.01 * flightSpeed;
                            look = entity.getLookAngle();
                            motion = entity.getDeltaMovement();
                            entity.setDeltaMovement(motion.add(look.x * accel + (look.x * speed - motion.x) * accel, look.y * accel + (look.y * speed - motion.y) * accel, look.z * accel + (look.z * speed - motion.z) * accel));
                            energy = (int)((double)energy + (double)EquipCfg.getElytraEnergy(module.getModule().getModuleTechLevel()) * flightSpeed);
                        }
                    }
                    finally {
                        if (host != null) {
                            host.close();
                        }
                    }
                }
                if (!entity.level().isClientSide && !creative) {
                    storage.modifyEnergyStored((long)(-energy));
                }
            }
        }
        return true;
    }

    public static ItemStack getArmor(LivingEntity entity) {
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.CHEST);
        if (stack.getItem() instanceof IModularArmor) {
            return stack;
        }
        return EquipmentManager.findItem(e -> e.getItem() instanceof IModularArmor, entity);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

