/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorSaveData;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.GroundTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.ItemData;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BoundDislocator
extends Dislocator {
    public BoundDislocator(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world instanceof ServerLevel && TimeKeeper.getServerTick() % 20 == 0 && BoundDislocator.isValid(stack) && !BoundDislocator.isPlayer(stack) && entity instanceof Player) {
            DislocatorSaveData.updateLinkTarget(world, stack, new PlayerTarget((Player)entity));
        }
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
    }

    @Override
    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0 && entity.pickupDelay != Short.MAX_VALUE) {
            entity.setExtendedLifetime();
        }
        if (entity.level() instanceof ServerLevel && TimeKeeper.getServerTick() % 20 == 0 && BoundDislocator.isValid(stack) && !BoundDislocator.isPlayer(stack)) {
            DislocatorSaveData.updateLinkTarget(entity.level(), stack, new GroundTarget(entity));
        }
        return false;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        ServerLevel serverLevel;
        if (player.level().isClientSide) {
            return true;
        }
        TargetPos location = this.getTargetPos(stack, player.level());
        if (location == null) {
            if (BoundDislocator.isPlayer(stack)) {
                player.sendSystemMessage((Component)Component.translatable((String)"dislocate.draconicevolution.bound.cant_find_player").withStyle(ChatFormatting.RED));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"dislocate.draconicevolution.bound.cant_find_target").withStyle(ChatFormatting.RED));
            }
            return true;
        }
        MinecraftServer server = player.getServer();
        if (server == null || !((serverLevel = server.getLevel(location.getDimension())) instanceof Level)) {
            return true;
        }
        ServerLevel targetLevel = serverLevel;
        if (!entity.canChangeDimensions(entity.level(), (Level)targetLevel) || !(entity instanceof LivingEntity)) {
            return true;
        }
        BCoreNetwork.sendSound((Level)player.level(), (BlockPos)player.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.level().random.nextFloat() * 0.1f + 0.9f), (boolean)false);
        BoundDislocator.notifyArriving(stack, player.level(), entity);
        location.teleport(entity);
        BCoreNetwork.sendSound((Level)player.level(), (BlockPos)player.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.level().random.nextFloat() * 0.1f + 0.9f), (boolean)false);
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.level().isClientSide) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (stack.getItem() == DEContent.DISLOCATOR_P2P_UNBOUND.get()) {
            UUID linkID = UUID.randomUUID();
            ItemStack boundA = BoundDislocator.createP2PDislocator(linkID);
            ItemStack boundB = BoundDislocator.createP2PDislocator(linkID);
            player.setItemInHand(hand, ItemStack.EMPTY);
            InventoryUtils.givePlayerStack((Player)player, (ItemStack)boundA);
            InventoryUtils.givePlayerStack((Player)player, (ItemStack)boundB);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (stack.getItem() == DEContent.DISLOCATOR_PLAYER_UNBOUND.get()) {
            ItemStack bound = new ItemStack((ItemLike)DEContent.DISLOCATOR_PLAYER.get());
            BoundDislocator.setPlayerID(bound, player.getUUID());
            BoundDislocator.setDislocatorId(stack, UUID.randomUUID());
            bound.set(ItemData.DISLOCATOR_PLAYER_NAME, (Object)player.getName().getString());
            player.setItemInHand(hand, ItemStack.EMPTY);
            InventoryUtils.givePlayerStack((Player)player, (ItemStack)bound);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        TargetPos location = this.getTargetPos(stack, level);
        if (location == null) {
            if (BoundDislocator.isPlayer(stack)) {
                player.sendSystemMessage((Component)Component.translatable((String)"dislocate.draconicevolution.bound.cant_find_player").withStyle(ChatFormatting.RED));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"dislocate.draconicevolution.bound.cant_find_target").withStyle(ChatFormatting.RED));
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BCoreNetwork.sendSound((Level)player.level(), (BlockPos)player.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.level().random.nextFloat() * 0.1f + 0.9f), (boolean)false);
        BoundDislocator.notifyArriving(stack, player.level(), (Entity)player);
        location.teleport((Entity)player);
        BCoreNetwork.sendSound((Level)player.level(), (BlockPos)player.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.level().random.nextFloat() * 0.1f + 0.9f), (boolean)false);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static boolean isPlayer(ItemStack stack) {
        return stack.getItem() == DEContent.DISLOCATOR_PLAYER.get();
    }

    public static boolean isP2P(ItemStack stack) {
        return stack.getItem() == DEContent.DISLOCATOR_P2P.get();
    }

    @Nullable
    public static UUID getPlayerID(ItemStack stack) {
        return (UUID)stack.get(ItemData.DISLOCATOR_PLAYER_ID);
    }

    public static void setPlayerID(ItemStack stack, @Nullable UUID playerID) {
        stack.set(ItemData.DISLOCATOR_PLAYER_ID, (Object)playerID);
    }

    @Nullable
    public static UUID getDislocatorId(ItemStack stack) {
        return (UUID)stack.get(ItemData.DISLOCATOR_STACK_ID);
    }

    private static void setDislocatorId(ItemStack stack, @Nullable UUID dislocatorID) {
        stack.set(ItemData.DISLOCATOR_STACK_ID, (Object)dislocatorID);
    }

    @Nullable
    public static UUID getLinkId(ItemStack stack) {
        return (UUID)stack.get(ItemData.DISLOCATOR_LINK_ID);
    }

    private static void setLinkId(ItemStack stack, @Nullable UUID linkID) {
        stack.set(ItemData.DISLOCATOR_LINK_ID, (Object)linkID);
    }

    public static boolean isValid(ItemStack stack) {
        if (stack.getItem() instanceof BoundDislocator) {
            return BoundDislocator.getLinkId(stack) != null && BoundDislocator.getDislocatorId(stack) != null;
        }
        return false;
    }

    private static ItemStack createP2PDislocator(UUID linkID) {
        ItemStack stack = new ItemStack((ItemLike)DEContent.DISLOCATOR_P2P.get());
        BoundDislocator.setLinkId(stack, linkID);
        BoundDislocator.setDislocatorId(stack, UUID.randomUUID());
        return stack;
    }

    @Override
    public TargetPos getTargetPos(ItemStack stack, @Nullable Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (BoundDislocator.isPlayer(stack)) {
                ServerPlayer player;
                UUID playerID = BoundDislocator.getPlayerID(stack);
                MinecraftServer server = serverLevel.getServer();
                if (playerID != null && (player = server.getPlayerList().getPlayer(playerID)) != null) {
                    return TargetPos.of((Entity)player);
                }
            } else {
                DislocatorTarget target = DislocatorSaveData.getLinkTarget(level, stack);
                UUID linkID = BoundDislocator.getLinkId(stack);
                if (target != null && linkID != null) {
                    return target.getTargetPos(level.getServer(), linkID, BoundDislocator.getDislocatorId(stack));
                }
            }
        }
        return null;
    }

    public static void notifyArriving(ItemStack stack, Level world, Entity entity) {
        DislocatorTarget target;
        if (world instanceof ServerLevel && (target = DislocatorSaveData.getLinkTarget(world, stack)) != null) {
            target.preTeleport(world.getServer(), entity);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.getItem() == DEContent.DISLOCATOR_P2P_UNBOUND.get()) {
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.bound.click_to_link").withStyle(ChatFormatting.GREEN));
        } else if (stack.getItem() == DEContent.DISLOCATOR_PLAYER_UNBOUND.get()) {
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.bound.click_to_link_self").withStyle(ChatFormatting.GREEN));
        } else if (BoundDislocator.isPlayer(stack)) {
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.bound.player_link").append(": ").append((String)stack.getOrDefault(ItemData.DISLOCATOR_PLAYER_NAME, (Object)"Unknown Player")).withStyle(ChatFormatting.BLUE));
        } else {
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.bound.link_id").append(": ").append(String.valueOf(BoundDislocator.getLinkId(stack))).withStyle(ChatFormatting.BLUE));
        }
    }

    @Override
    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }
}

