/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors.crush;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.recipe.RecipeWrapper;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class ImmersiveEngineeringCrusherProcessor
extends Processor<RecipeInput, CrusherRecipe> {
    public ImmersiveEngineeringCrusherProcessor(MinecraftServer server) {
        super(server, (RecipeType)IERecipeTypes.CRUSHER.type().get());
    }

    @Override
    public Set<Item> getExistingInputs() {
        return ArsUnification.crushRecipesIngredientSet(this.recipeManager());
    }

    @Override
    @Nullable
    public Ingredient getIngredient(CrusherRecipe recipe) {
        return recipe.input;
    }

    @Override
    @Nullable
    public RecipeHolder<?> processCommon(Set<Item> existing, RecipeHolder<? extends CrusherRecipe> recipeHolder, Ingredient ingredient) {
        CrusherRecipe recipe = (CrusherRecipe)recipeHolder.value();
        RecipeWrapper.Crush wrapper = new RecipeWrapper.Crush(recipeHolder.id(), ingredient).withItems(recipe.output.get());
        for (StackWithChance output : recipe.secondaryOutputs) {
            wrapper = wrapper.withItems(output.stack().get(), output.chance());
        }
        return wrapper.asHolder();
    }
}

