/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.fluidharvesting;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.swedz.extended_industrialization.machines.component.fluidharvesting.FluidHarvestingBehavior;
import net.swedz.extended_industrialization.machines.component.fluidharvesting.FluidHarvestingBehaviorCreator;
import net.swedz.tesseract.neoforge.compat.mi.helper.EuConsumerBehavior;

public abstract class FluidHarvestingMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    protected static final int OUTPUT_SLOT_X = 110;
    protected static final int OUTPUT_SLOT_Y = 30;
    protected final long euCost;
    protected final FluidHarvestingBehaviorCreator behaviorCreator;
    protected FluidHarvestingBehavior behavior;
    protected final IsActiveComponent isActiveComponent;
    protected int pumpingTicks;

    public FluidHarvestingMachineBlockEntity(BEP bep, ResourceLocation blockName, long euCost, FluidHarvestingBehaviorCreator behaviorCreator) {
        super(bep, new MachineGuiParameters.Builder(blockName, false).build(), new OrientationComponent.Params(true, false, true));
        this.euCost = euCost;
        this.behaviorCreator = behaviorCreator;
        this.isActiveComponent = new IsActiveComponent();
        this.registerGuiComponent(new GuiComponentServer[]{new ProgressBar(new ProgressBar.Params(79, 29, "extract"), () -> Float.valueOf((float)this.pumpingTicks / (float)this.getFluidHarvestingBehavior().totalPumpingTicks()))});
        this.registerGuiComponent(new GuiComponentServer[]{new AutoExtract(this.orientation)});
        this.registerComponents(new MachineComponent[]{this.isActiveComponent, new MachineComponent(){

            public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
                tag.putInt("pumpingTicks", FluidHarvestingMachineBlockEntity.this.pumpingTicks);
            }

            public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
                FluidHarvestingMachineBlockEntity.this.pumpingTicks = tag.getInt("pumpingTicks");
            }
        }});
    }

    protected abstract EuConsumerBehavior createEuConsumerBehavior();

    public FluidHarvestingBehavior getFluidHarvestingBehavior() {
        if (this.behavior == null) {
            this.behavior = this.behaviorCreator.create(this, this.createEuConsumerBehavior());
        }
        return this.behavior;
    }

    public abstract boolean isEnabled();

    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        boolean active = false;
        if (this.isEnabled() && this.getFluidHarvestingBehavior().canOperate()) {
            long eu = this.getFluidHarvestingBehavior().consumeEu(this.euCost);
            active = eu > 0L;
            this.pumpingTicks += active ? 1 : 0;
            this.updateActive(active);
            if (this.pumpingTicks == this.getFluidHarvestingBehavior().totalPumpingTicks()) {
                this.getFluidHarvestingBehavior().operate();
                this.pumpingTicks = 0;
            }
        }
        if (this.orientation.extractFluids) {
            this.getInventory().autoExtractFluids(this.level, this.worldPosition, this.orientation.outputDirection);
        }
        this.updateActive(active);
        this.setChanged();
    }

    private void updateActive(boolean active) {
        this.isActiveComponent.updateActive(active, (MachineBlockEntity)this);
    }

    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }
}

