/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.fluidharvesting;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.machines.blockentity.fluidharvesting.FluidHarvestingMachineBlockEntity;
import net.swedz.extended_industrialization.machines.component.fluidharvesting.FluidHarvestingBehaviorCreator;
import net.swedz.tesseract.neoforge.compat.mi.helper.EuConsumerBehavior;

public final class SteamFluidHarvestingMachineBlockEntity
extends FluidHarvestingMachineBlockEntity {
    private final MIInventory inventory;

    public SteamFluidHarvestingMachineBlockEntity(BEP bep, ResourceLocation blockName, long euCost, FluidHarvestingBehaviorCreator behaviorCreator, long capacity, FluidLike fluid) {
        super(bep, blockName, euCost, behaviorCreator);
        List<ConfigurableFluidStack> fluidStacks = Arrays.asList(ConfigurableFluidStack.lockedInputSlot((long)capacity, (Fluid)MIFluids.STEAM.asFluid()), ConfigurableFluidStack.lockedOutputSlot((long)capacity, (Fluid)fluid.asFluid()));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(21, 30).addSlot(110, 30).build();
        this.inventory = new MIInventory(Collections.emptyList(), fluidStacks, SlotPositions.empty(), fluidPositions);
        this.registerComponents(new MachineComponent[]{this.inventory});
    }

    @Override
    protected EuConsumerBehavior createEuConsumerBehavior() {
        return EuConsumerBehavior.steam((MachineBlockEntity)this);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public MIInventory getInventory() {
        return this.inventory;
    }
}

