/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.tesla;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIDamageTypes;
import net.swedz.extended_industrialization.EISounds;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaBehavior;
import net.swedz.extended_industrialization.machines.component.enchantmentmodule.EnchantmentModuleComponent;
import net.swedz.extended_industrialization.machines.component.tesla.AestheticTeslaCoilComponent;
import net.swedz.extended_industrialization.machines.component.tesla.LethalTeslaCoilComponent;
import net.swedz.extended_industrialization.machines.component.tesla.TeslaBuzzingComponent;
import net.swedz.extended_industrialization.machines.guicomponent.EIModularSlotPanelSlots;
import net.swedz.extended_industrialization.proxy.EIProxy;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.component.SimpleItemStackComponent;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.slotpanel.ModularSlotPanel;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import org.joml.Vector3f;

public final class LethalTeslaCoilMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
EnergyComponentHolder,
TeslaBehavior {
    private static final long DAMAGE_INTERVAL = 20L;
    private final IsActiveComponent isActive = new IsActiveComponent();
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final CasingComponent casing = new CasingComponent();
    private final EnchantmentModuleComponent enchantmentModule = new EnchantmentModuleComponent(EITags.Items.EnchantmentModules.LETHAL_TESLA_COIL);
    private final EnergyComponent energy = new EnergyComponent((BlockEntity)this, () -> 600L * this.casing.getCableTier().eu);
    private final MIEnergyStorage insertable = this.energy.buildInsertable(arg_0 -> ((CasingComponent)this.casing).canInsertEu(arg_0));
    private final LethalTeslaCoilComponent lethal = new LethalTeslaCoilComponent(this, () -> Float.valueOf(LethalTeslaCoilMachineBlockEntity.getDamageAmount(this.casing.getCableTier())), this.energy, () -> LethalTeslaCoilMachineBlockEntity.getEnergyCost(this.casing.getCableTier()) + this.enchantmentModule.getAdditionalEuCost(this.casing.getCableTier()), () -> EI.config().lethalTeslaCoil().range(), () -> 20L, () -> EIDamageTypes.teslaFakePlayer(this.level, this.worldPosition.getCenter(), this.placedBy.placerId, this.enchantmentModule.getActiveEnchantment(), this.casing.getCableTier()));
    private final TeslaBuzzingComponent buzzing = new TeslaBuzzingComponent(this, EISounds.TESLA_COIL_LOOP.get(), SoundSource.BLOCKS, this.lethal::hasNearbyEntities, () -> Float.valueOf(1.0f));
    private final AestheticTeslaCoilComponent aesthetic = new AestheticTeslaCoilComponent();

    public static long getEnergyCost(CableTier tier) {
        return tier.eu / 8L;
    }

    public static float getDamageAmount(CableTier tier) {
        return (float)Mth.clamp((double)EI.config().lethalTeslaCoil().damage().get(tier), (double)0.0, (double)2.147483647E9);
    }

    public LethalTeslaCoilMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(EI.id("lethal_tesla_coil"), false).build(), new OrientationComponent.Params(false, false, false));
        this.registerComponents(new MachineComponent[]{this.isActive, this.redstoneControl, this.casing, this.enchantmentModule, this.energy, this.lethal, this.buzzing, this.aesthetic});
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new EnergyBar(new EnergyBar.Params(81, 34), () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(guiComponentServerArray);
        this.registerGuiComponent(new GuiComponentServer[]{new ModularSlotPanel((MachineBlockEntity)this, 0).withRedstoneModule(this.redstoneControl).withCasings(this.casing).with(EIModularSlotPanelSlots.LETHAL_TESLA_COIL_ENCHANTMENT_MODULE, (SimpleItemStackComponent)this.enchantmentModule)});
        ConfigurationPanelBuilder configPanel = new ConfigurationPanelBuilder((Component)EI.text().configurationPanel(), (Component)EI.text().configurationPanelDescription(), (lineIndex, delta) -> this.sync());
        this.aesthetic.appendSelectionPanel(this, configPanel);
        this.registerGuiComponent(new GuiComponentServer[]{configPanel.build()});
    }

    @Override
    public boolean shouldTeslaRender() {
        return this.isActive.isActive;
    }

    @Override
    public ResourceLocation getTeslaModelLocation() {
        return EI.id("tesla/lethal_tesla_coil");
    }

    @Override
    public Vector3f getTeslaColor() {
        return this.aesthetic.getColor();
    }

    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.casing.getCasing());
        data.isActive = this.isActive.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).removeTesla(this.worldPosition);
        }
    }

    public void tick() {
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).tickTesla(this.worldPosition);
            this.buzzing.tick();
            return;
        }
        boolean active = false;
        if (this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this)) {
            active = this.lethal.tick();
        }
        this.isActive.updateActive(active, (MachineBlockEntity)this);
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.casing.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.aesthetic.onUse(this, player, hand);
        }
        return result;
    }

    public List<Component> getTooltips() {
        ArrayList lines = Lists.newArrayList();
        lines.add(EI.text().teslaLethalCoilHelp1(EI.config().lethalTeslaCoil().range()));
        lines.add(EI.text().teslaLethalCoilValues());
        for (CableTier tier : CableTier.allTiers()) {
            lines.add(EI.text().voltageValueForCost(tier, LethalTeslaCoilMachineBlockEntity.getDamageAmount(tier), LethalTeslaCoilMachineBlockEntity.getEnergyCost(tier)));
        }
        return lines;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        CapabilitiesListeners.register((String)"extended_industrialization", event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((LethalTeslaCoilMachineBlockEntity)be).insertable));
    }
}

