/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.tesla;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.helper.EnergyHelper;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaBehavior;
import net.swedz.extended_industrialization.machines.component.tesla.AestheticTeslaCoilComponent;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetwork;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiver;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiverComponent;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiverState;
import net.swedz.extended_industrialization.machines.guicomponent.teslanetwork.TeslaNetworkBar;
import net.swedz.extended_industrialization.proxy.EIProxy;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanelBuilder;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import org.joml.Vector3f;

public final class TeslaReceiverMachineBlockEntity
extends MachineBlockEntity
implements TeslaReceiver.Delegate,
Tickable,
TeslaBehavior {
    private final IsActiveComponent isActive = new IsActiveComponent();
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final CasingComponent casing = new CasingComponent(this::onCasingUpdate);
    private final EnergyComponent energy = new EnergyComponent((BlockEntity)this, () -> 600L * this.casing.getCableTier().eu);
    private final MIEnergyStorage insertable = this.energy.buildInsertable(arg_0 -> ((CasingComponent)this.casing).canInsertEu(arg_0));
    private final MIEnergyStorage extractable = this.energy.buildExtractable(arg_0 -> ((CasingComponent)this.casing).canInsertEu(arg_0));
    private final AestheticTeslaCoilComponent aesthetic = new AestheticTeslaCoilComponent();
    private final TeslaReceiverComponent receiver = new TeslaReceiverComponent(this, this.insertable, () -> this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this), () -> ((CasingComponent)this.casing).getCableTier());

    public TeslaReceiverMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(EI.id("tesla_receiver"), false).build(), new OrientationComponent.Params(true, false, false));
        this.registerComponents(new MachineComponent[]{this.isActive, this.redstoneControl, this.casing, this.energy, this.aesthetic, this.receiver});
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new EnergyBar(new EnergyBar.Params(61, 34), () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(guiComponentServerArray);
        this.registerGuiComponent(new GuiComponentServer[]{new TeslaNetworkBar(new TeslaNetworkBar.Params(101, 34), () -> {
            if (this.hasNetwork()) {
                TeslaNetwork network = this.getNetwork();
                if (network.isTransmitterLoaded()) {
                    TeslaReceiverState state = this.checkReceiveFrom(network);
                    return Optional.of(new TeslaNetworkBar.ReceiverData(state, Optional.of(this.getNetworkKey()), Optional.of(network.getCableTier())));
                }
                return Optional.of(new TeslaNetworkBar.ReceiverData(TeslaReceiverState.UNLOADED_TRANSMITTER, Optional.of(this.getNetworkKey()), Optional.empty()));
            }
            return Optional.of(new TeslaNetworkBar.ReceiverData(TeslaReceiverState.NO_LINK, Optional.empty(), Optional.empty()));
        })});
        this.registerGuiComponent(new GuiComponentServer[]{new SlotPanel((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withCasing(this.casing)});
        ConfigurationPanelBuilder configPanel = new ConfigurationPanelBuilder((Component)EI.text().configurationPanel(), (Component)EI.text().configurationPanelDescription(), (lineIndex, delta) -> this.sync());
        this.receiver.appendSelectionPanel(this, configPanel);
        this.aesthetic.appendSelectionPanel(this, configPanel);
        this.registerGuiComponent(new GuiComponentServer[]{configPanel.build()});
    }

    private void onCasingUpdate(CableTier from, CableTier to) {
        if (this.level != null && !this.level.isClientSide()) {
            this.receiver.addToNetwork();
        }
    }

    @Override
    public boolean shouldTeslaRender() {
        return this.isActive.isActive;
    }

    @Override
    public ResourceLocation getTeslaModelLocation() {
        return EI.id("tesla/tesla_receiver");
    }

    @Override
    public Vector3f getTeslaColor() {
        return this.aesthetic.getColor();
    }

    @Override
    public TeslaReceiver getDelegateReceiver() {
        return this.receiver;
    }

    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.casing.getCasing());
        data.isActive = this.isActive.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide()) {
            return;
        }
        this.receiver.addToNetwork();
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).removeTesla(this.worldPosition);
            return;
        }
        this.receiver.removeFromNetwork();
    }

    public void tick() {
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).tickTesla(this.worldPosition);
            return;
        }
        if (this.hasNetwork() && this.getNetwork().isTransmitterLoaded() && this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this)) {
            TeslaNetwork network = this.getNetwork();
            this.isActive.updateActive(network.isTransmitterLoaded() && this.checkReceiveFrom(network).isSuccess(), (MachineBlockEntity)this);
            EnergyHelper.autoOutput((MachineBlockEntity)this, (OrientationComponent)this.orientation, (CableTier)this.casing.getCableTier(), (MIEnergyStorage)this.extractable);
        } else {
            this.isActive.updateActive(false, (MachineBlockEntity)this);
        }
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.casing.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.aesthetic.onUse(this, player, hand);
        }
        return result;
    }

    public List<Component> getTooltips() {
        return List.of(EI.text().teslaReceiverHelp1(), EI.text().teslaReceiverHelp2());
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        CapabilitiesListeners.register((String)"extended_industrialization", event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> {
            TeslaReceiverMachineBlockEntity machine = (TeslaReceiverMachineBlockEntity)be;
            return machine.orientation.outputDirection == direction ? machine.extractable : null;
        }));
    }
}

