/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer;

import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.swedz.extended_industrialization.EILocalizedListeners;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.farmer.FarmerBlockEntity;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponentPlantableStacks;
import net.swedz.extended_industrialization.machines.component.farmer.PlantingMode;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerBlockMap;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.FarmerListener;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestableBehavior;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestableBehaviorHolder;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestingContext;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.harvestable.BushBlockHarvestable;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.harvestable.GrowingPlantHarvestable;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.harvestable.SimpleTallCropHarvestable;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.harvestable.TreeHarvestable;
import net.swedz.extended_industrialization.machines.component.farmer.planting.FarmerPlantable;
import net.swedz.extended_industrialization.machines.component.farmer.planting.PlantableBehaviorHolder;
import net.swedz.extended_industrialization.machines.component.farmer.planting.PlantingContext;
import net.swedz.extended_industrialization.machines.component.farmer.planting.plantable.SpecialFarmerPlantable;
import net.swedz.extended_industrialization.machines.component.farmer.planting.plantable.StandardFarmerPlantable;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerProcessRates;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskType;
import net.swedz.tesseract.neoforge.behavior.BehaviorRegistry;
import net.swedz.tesseract.neoforge.compat.mi.helper.MachineInventoryHelper;
import net.swedz.tesseract.neoforge.event.FarmlandLoseMoistureEvent;

public final class FarmerComponent
implements MachineComponent {
    private static final BehaviorRegistry<PlantableBehaviorHolder, FarmerPlantable, PlantingContext> PLANTABLE_REGISTRY = BehaviorRegistry.create(PlantableBehaviorHolder::new);
    private static final BehaviorRegistry<HarvestableBehaviorHolder, HarvestableBehavior, HarvestingContext> HARVESTABLE_REGISTRY = BehaviorRegistry.create(HarvestableBehaviorHolder::new);
    private final FarmerBlockEntity machine;
    private final MultiblockInventoryComponent inventory;
    private final FarmerComponentPlantableStacks plantableStacks;
    private final PlantingMode defaultPlantingMode;
    private final FarmerProcessRates processRates;
    private final FarmerBlockMap blockMap;
    private final PlantableBehaviorHolder plantableBehaviorHolder;
    private final HarvestableBehaviorHolder harvestableBehaviorHolder;
    private final List<FarmerTask> tasks;
    private final List<FarmerListener<? extends Event>> listeners = Lists.newArrayList();
    private Level level;
    private boolean listenersRegistered = false;
    public PlantingMode plantingMode;
    public boolean tilling;
    private int processTick;

    public static void registerPlantable(Supplier<FarmerPlantable> creator) {
        PLANTABLE_REGISTRY.register(creator);
    }

    public static void registerHarvestable(Supplier<HarvestableBehavior> creator) {
        HARVESTABLE_REGISTRY.register(creator);
    }

    public FarmerComponent(FarmerBlockEntity machine, MultiblockInventoryComponent inventory, PlantingMode defaultPlantingMode, FarmerProcessRates processRates) {
        this.machine = machine;
        this.inventory = inventory;
        this.plantableStacks = new FarmerComponentPlantableStacks(this);
        this.defaultPlantingMode = defaultPlantingMode;
        this.plantingMode = defaultPlantingMode;
        this.processRates = processRates;
        this.blockMap = new FarmerBlockMap();
        this.plantableBehaviorHolder = (PlantableBehaviorHolder)PLANTABLE_REGISTRY.createHolder();
        this.harvestableBehaviorHolder = (HarvestableBehaviorHolder)HARVESTABLE_REGISTRY.createHolder();
        this.tasks = Stream.of(FarmerTaskType.values()).filter(processRates::contains).map(task -> task.create(this)).toList();
        this.listeners.add(new FarmerListener<BlockEvent.FarmlandTrampleEvent>(BlockEvent.FarmlandTrampleEvent.class, event -> {
            if (this.tilling && this.blockMap.containsDirtAt(event.getPos())) {
                event.setCanceled(true);
            }
        }));
        this.listeners.add(new FarmerListener<FarmlandLoseMoistureEvent>(FarmlandLoseMoistureEvent.class, event -> {
            if (this.tilling && this.blockMap.containsDirtAt(event.getPos()) && FarmerComponent.consumeWater(inventory, Simulation.SIMULATE)) {
                FarmerComponent.consumeWater(inventory, Simulation.ACT);
                event.setCanceled(true);
            }
        }));
        this.listeners.addAll(this.harvestableBehaviorHolder.listeners(this.blockMap));
    }

    public FarmerBlockEntity getMachine() {
        return this.machine;
    }

    public MultiblockInventoryComponent getInventory() {
        return this.inventory;
    }

    public FarmerBlockMap getBlockMap() {
        return this.blockMap;
    }

    public PlantableBehaviorHolder getPlantableBehaviorHolder() {
        return this.plantableBehaviorHolder;
    }

    public HarvestableBehaviorHolder getHarvestableBehaviorHolder() {
        return this.harvestableBehaviorHolder;
    }

    public FarmerComponentPlantableStacks getPlantableStacks() {
        return this.plantableStacks;
    }

    public FarmerProcessRates getProcessRates() {
        return this.processRates;
    }

    public static boolean consumeWater(MultiblockInventoryComponent inventory, Simulation simulation) {
        return MachineInventoryHelper.consumeFluid((List)inventory.getFluidInputs(), (Fluid)Fluids.WATER, (long)50L, (Simulation)simulation) == 50L;
    }

    public void fromOffsets(BlockPos controllerPos, Direction controllerDirection, List<BlockPos> offsets) {
        this.blockMap.fromOffsets(this.level, controllerPos, controllerDirection, offsets);
    }

    public void updateStackListeners() {
        this.plantableStacks.update(this.inventory.getItemInputs());
    }

    public List<Component> getTaskTooltipLines() {
        return this.tasks.stream().map(task -> task.type().tooltip()).filter(Objects::nonNull).toList();
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        ++this.processTick;
        this.blockMap.markDirty();
        boolean hasWater = FarmerComponent.consumeWater(this.inventory, Simulation.SIMULATE);
        for (FarmerTask task : this.tasks) {
            task.run(this.level, this.plantingMode, this.tilling, this.processTick, hasWater);
        }
        if (this.processTick >= 1200) {
            this.processTick = 0;
        }
    }

    public void registerListeners(Level level, ShapeMatcher shapeMatcher) {
        if (this.listenersRegistered) {
            throw new IllegalStateException("There are already listeners registered on this FarmerComponent");
        }
        this.listenersRegistered = true;
        this.level = level;
        for (FarmerListener<? extends Event> listener : this.listeners) {
            EILocalizedListeners.INSTANCE.register(level, shapeMatcher.getSpannedChunks(), listener.eventClass(), listener.listener());
        }
    }

    public void unregisterListeners(Level level, ShapeMatcher shapeMatcher) {
        for (FarmerListener<? extends Event> listener : this.listeners) {
            EILocalizedListeners.INSTANCE.unregister(level, shapeMatcher.getSpannedChunks(), listener.eventClass(), listener.listener());
        }
        this.listenersRegistered = false;
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putBoolean("tilling", this.tilling);
        tag.putString("planting_mode", this.plantingMode.name());
        CompoundTag harvestingHandlersCache = new CompoundTag();
        for (HarvestableBehavior harvestingHandler : this.harvestableBehaviorHolder.behaviors()) {
            harvestingHandler.writeNbt(harvestingHandlersCache);
        }
        tag.put("harvesting_handlers", (Tag)harvestingHandlersCache);
        CompoundTag tasksTag = new CompoundTag();
        for (FarmerTask task : this.tasks) {
            CompoundTag taskTag = new CompoundTag();
            task.writeNbt(taskTag);
            if (taskTag.isEmpty()) continue;
            tasksTag.put(task.type().name(), (Tag)taskTag);
        }
        if (!tasksTag.isEmpty()) {
            tag.put("tasks", (Tag)tasksTag);
        }
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.tilling = tag.getBoolean("tilling");
        this.plantingMode = PlantingMode.fromName(tag.getString("planting_mode"));
        if (this.plantingMode == null) {
            this.plantingMode = this.defaultPlantingMode;
        }
        CompoundTag harvestingHandlersCache = tag.getCompound("harvesting_handlers");
        for (HarvestableBehavior harvestingHandler : this.harvestableBehaviorHolder.behaviors()) {
            harvestingHandler.readNbt(harvestingHandlersCache);
        }
        CompoundTag tasksTag = tag.getCompound("tasks");
        if (!tasksTag.isEmpty()) {
            for (FarmerTask task : this.tasks) {
                CompoundTag taskTag = tasksTag.getCompound(task.type().name());
                task.readNbt(taskTag, isUpgradingMachine);
            }
        }
    }

    static {
        FarmerComponent.registerPlantable(StandardFarmerPlantable::new);
        FarmerComponent.registerPlantable(SpecialFarmerPlantable::new);
        FarmerComponent.registerHarvestable(BushBlockHarvestable::new);
        FarmerComponent.registerHarvestable(GrowingPlantHarvestable::new);
        FarmerComponent.registerHarvestable(SimpleTallCropHarvestable::new);
        FarmerComponent.registerHarvestable(TreeHarvestable::new);
    }
}

