/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.teslanetwork;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiverState;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.compat.mi.serialization.MIStreamCodecs;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public final class TeslaNetworkBar
implements GuiComponentServer<Params, Optional<Data>> {
    private static final Map<String, StreamCodec<ByteBuf, ? extends Data<?>>> DATA_TYPES = Map.of("transmitter", TransmitterData.STREAM_CODEC, "receiver", ReceiverData.STREAM_CODEC, "singing", SingingData.STREAM_CODEC);
    public static final GuiComponentServer.Type<Params, Optional<Data>> TYPE = new GuiComponentServer.Type(EI.id("tesla_network_bar"), Params.STREAM_CODEC, ByteBufCodecs.optional(Data.STREAM_CODEC));
    private final Params params;
    private final Supplier<Optional<Data>> data;

    public TeslaNetworkBar(Params params, Supplier<Optional<Data>> data) {
        this.params = params;
        this.data = data;
    }

    public Params getParams() {
        return this.params;
    }

    public Optional<Data> extractData() {
        return this.data.get();
    }

    public GuiComponentServer.Type<Params, Optional<Data>> getType() {
        return TYPE;
    }

    public record Params(int renderX, int renderY) {
        public static final StreamCodec<ByteBuf, Params> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Params::renderX, (StreamCodec)ByteBufCodecs.VAR_INT, Params::renderY, Params::new);
    }

    public record TransmitterData(int receivers, long energyTransmitting, CableTier cableTier, long energyDrain, long energyConsuming) implements Data<TransmitterData>
    {
        private static final String ID = "transmitter";
        public static final StreamCodec<ByteBuf, TransmitterData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, TransmitterData::receivers, (StreamCodec)ByteBufCodecs.VAR_LONG, TransmitterData::energyTransmitting, (StreamCodec)MIStreamCodecs.CABLE_TIER, TransmitterData::cableTier, (StreamCodec)ByteBufCodecs.VAR_LONG, TransmitterData::energyDrain, (StreamCodec)ByteBufCodecs.VAR_LONG, TransmitterData::energyConsuming, TransmitterData::new);

        @Override
        public String id() {
            return ID;
        }

        @Override
        public int iconIndex() {
            return 1;
        }
    }

    public record ReceiverData(TeslaReceiverState state, Optional<WorldPos> linked, Optional<CableTier> networkCableTier) implements Data<ReceiverData>
    {
        private static final String ID = "receiver";
        public static final StreamCodec<ByteBuf, ReceiverData> STREAM_CODEC = StreamCodec.composite((StreamCodec)CodecHelper.forEnumStream(TeslaReceiverState.class), ReceiverData::state, (StreamCodec)ByteBufCodecs.optional((StreamCodec)WorldPos.STREAM_CODEC), ReceiverData::linked, (StreamCodec)ByteBufCodecs.optional((StreamCodec)MIStreamCodecs.CABLE_TIER), ReceiverData::networkCableTier, ReceiverData::new);

        @Override
        public String id() {
            return ID;
        }

        @Override
        public int iconIndex() {
            if (this.state.isFailure()) {
                return switch (this.state) {
                    case TeslaReceiverState.NO_LINK -> 0;
                    case TeslaReceiverState.UNLOADED_TRANSMITTER -> 3;
                    case TeslaReceiverState.MISMATCHING_VOLTAGE -> 4;
                    case TeslaReceiverState.TOO_FAR -> 5;
                    case TeslaReceiverState.UNDEFINED -> 2;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.state));
                };
            }
            return 1;
        }
    }

    public record SingingData(int note, long energyConsuming) implements Data<SingingData>
    {
        private static final String ID = "singing";
        public static final StreamCodec<ByteBuf, SingingData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SingingData::note, (StreamCodec)ByteBufCodecs.VAR_LONG, SingingData::energyConsuming, SingingData::new);
        private static final char ZERO = '\u2080';
        private static final char ONE = '\u2081';
        private static final char TWO = '\u2082';
        private static final String[] READABLE_NOTES = new String[]{"F#\u2080", "G\u2080", "G#\u2080", "A\u2080", "A#\u2080", "B\u2080", "C\u2080", "C#\u2080", "D\u2080", "D#\u2080", "E\u2080", "F\u2080", "F#\u2081", "G\u2081", "G#\u2081", "A\u2081", "A#\u2081", "B\u2081", "C\u2081", "C#\u2081", "D\u2081", "D#\u2081", "E\u2081", "F\u2081", "F#\u2082"};

        public String getReadableNote() {
            return READABLE_NOTES[this.note];
        }

        @Override
        public String id() {
            return ID;
        }

        @Override
        public int iconIndex() {
            return 6;
        }
    }

    public static interface Data<T extends Data<T>> {
        public static final StreamCodec<ByteBuf, Data> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.dispatch(Data::id, DATA_TYPES::get);

        public String id();

        public int iconIndex();
    }
}

