/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.proxy;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.swedz.extended_industrialization.EIClient;
import net.swedz.extended_industrialization.client.ber.tesla.TeslaPartRenderer;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaArcInstance;
import net.swedz.extended_industrialization.client.sound.TeslaCoilLoopSound;
import net.swedz.extended_industrialization.proxy.EIProxy;
import net.swedz.tesseract.neoforge.proxy.ProxyEntrypoint;
import net.swedz.tesseract.neoforge.proxy.ProxyEnvironment;

@ProxyEntrypoint(environment={ProxyEnvironment.CLIENT})
public class EIClientProxy
extends EIProxy {
    private static Direction ELECTRIC_TOOL_BREAKING_SIDE;

    public void init() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, event -> {
            if (event.getUseItem().isFalse() || event.getSide().isServer()) {
                return;
            }
            ELECTRIC_TOOL_BREAKING_SIDE = event.getFace();
        });
    }

    @Override
    public void tickTesla(BlockPos blockPos) {
        TeslaArcInstance arcInstance;
        if (EIClient.config().renderTeslaAnimations() && (arcInstance = TeslaPartRenderer.getArcInstance(blockPos)) != null) {
            arcInstance.tick();
        }
    }

    @Override
    public void createTeslaArc(BlockPos blockPos, Vec3 target) {
        TeslaArcInstance arcInstance;
        if (EIClient.config().renderTeslaAnimations() && (arcInstance = TeslaPartRenderer.getArcInstance(blockPos)) != null) {
            arcInstance.createArc(arcInstance.closestOrigin(target), target);
        }
    }

    @Override
    public void startTeslaCoilLoopSound(BlockPos origin, SoundEvent sound, SoundSource source, Supplier<Boolean> shouldStop, Supplier<Float> getPitch, Runnable onStop) {
        Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)new TeslaCoilLoopSound(origin, sound, source, shouldStop, getPitch, onStop));
    }

    @Override
    public void removeTesla(BlockPos blockPos) {
        TeslaPartRenderer.removeArcInstance(blockPos);
    }

    @Override
    public boolean shouldCauseElectricToolBreakReset() {
        BlockHitResult hitResult;
        HitResult hitResult2;
        return Minecraft.getInstance().isSameThread() && (hitResult2 = Minecraft.getInstance().hitResult) instanceof BlockHitResult && (hitResult = (BlockHitResult)hitResult2).getDirection() != ELECTRIC_TOOL_BREAKING_SIDE;
    }
}

