/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.EIRecipeTypes;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.component.RainbowDataComponent;

public final class RainbowableDyeRecipe
extends CustomRecipe {
    public RainbowableDyeRecipe(CraftingBookCategory category) {
        super(category);
    }

    private Optional<Match> find(CraftingInput input) {
        ItemStack dyeableItem = ItemStack.EMPTY;
        ArrayList dyeItems = Lists.newArrayList();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack item = input.getItem(i);
            if (item.isEmpty()) continue;
            if (item.is(ItemTags.DYEABLE) && item.is(EITags.Items.RAINBOW_DYEABLE)) {
                if (!dyeableItem.isEmpty()) {
                    return Optional.empty();
                }
                dyeableItem = item;
                continue;
            }
            Item item2 = item.getItem();
            if (!(item2 instanceof DyeItem)) {
                return Optional.empty();
            }
            DyeItem dyeItem = (DyeItem)item2;
            dyeItems.add(dyeItem);
        }
        return Optional.of(new Match(dyeableItem, dyeItems));
    }

    public boolean matches(CraftingInput input, Level level) {
        return this.find(input).map(Match::valid).orElse(false);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        return this.find(input).map(Match::assemble).orElse(ItemStack.EMPTY);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return EIRecipeTypes.RAINBOWABLE_DYE_SERIALIZER.get();
    }

    private record Match(ItemStack dyeableItem, List<DyeItem> dyeItems) {
        public boolean valid() {
            return !this.dyeableItem.isEmpty() && !this.dyeItems.isEmpty();
        }

        public boolean rainbow() {
            return this.dyeItems.size() == 3 && this.dyeItems.containsAll(List.of((DyeItem)Items.RED_DYE, (DyeItem)Items.LIME_DYE, (DyeItem)Items.BLUE_DYE));
        }

        public ItemStack assemble() {
            if (this.valid()) {
                if (this.rainbow()) {
                    ItemStack result = this.dyeableItem.copy();
                    result.remove(DataComponents.DYED_COLOR);
                    result.set(EIComponents.RAINBOW, (Object)new RainbowDataComponent(true, true));
                    return result;
                }
                return DyedItemColor.applyDyes((ItemStack)this.dyeableItem, this.dyeItems);
            }
            return ItemStack.EMPTY;
        }
    }
}

