/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.geneticsresequenced.category.Incubator;

import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.ftb.mods.ftbjeiextras.geneticsresequenced.category.AbstractGeneticsRecipeCategory;
import dev.ftb.mods.ftbjeiextras.geneticsresequenced.recipes.incubator.GMORecipe;
import dev.ftb.mods.ftbjeiextras.modspecific.GeneticsHelpers;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.ItemLike;

public class GMORecipeCategory
extends AbstractGeneticsRecipeCategory<GMORecipe> {
    public static final RecipeType<GMORecipe> TYPE = GeneticsHelpers.createRecipeType("gmo", GMORecipe.class);

    public GMORecipeCategory(IJeiHelpers helpers) {
        super(helpers, (ItemLike)ModItems.INSTANCE.getGMO_CELL(), "gmo", TYPE);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GMORecipe recipe, IFocusGroup focuses) {
        int displayHeight = 42;
        int buffer = 5;
        int slotSize = 18;
        int x = 0;
        builder.addInputSlot(x += 5, displayHeight / 4).addIngredients(recipe.getInput());
        builder.addInputSlot(x += slotSize + buffer, displayHeight / 4).addIngredients(recipe.getIngredient());
        builder.addOutputSlot(x += this.guiHelper.getRecipeArrow().getWidth() * 2 + 4, 2).addItemStack(recipe.getGoodOutput());
        builder.addOutputSlot(x, 22).addItemStack(recipe.getBadOutput());
    }

    public void draw(GMORecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 4, 9);
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 27, 9);
        this.guiHelper.getRecipeArrow().draw(guiGraphics, 49, 9);
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 75, 1);
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 75, 21);
        float successChance = recipe.getChance() * 100.0f;
        float failureChance = 100.0f - successChance;
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)(String.format("Success: %.1f", Float.valueOf(successChance)) + "%")), 96, 6, ChatFormatting.GREEN.getColor().intValue());
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)(String.format("Failure: %.1f", Float.valueOf(failureChance)) + "%")), 97, 26, ChatFormatting.RED.getColor().intValue());
    }

    public void getTooltip(ITooltipBuilder tooltip, GMORecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
        tooltip.add((FormattedText)Component.translatable((String)"tooltip.geneticsresequenced.gmo_temperature_requirement").withStyle(ChatFormatting.GRAY));
        tooltip.add((FormattedText)Component.empty());
        tooltip.add((FormattedText)Component.translatable((String)"tooltip.geneticsresequenced.gmo_recipe.line3").withStyle(ChatFormatting.GRAY));
    }

    public int getWidth() {
        return 174;
    }

    public int getHeight() {
        return 42;
    }
}

