/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.geneticsresequenced.recipes.incubator;

import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.neoforge.registries.DeferredHolder;

public class GMORecipe {
    private final Ingredient ingredient;
    private final Ingredient input;
    private final ItemStack goodOutput;
    private final ItemStack badOutput;
    private final float chance;

    public GMORecipe(EntityType<?> entityType, Ingredient ingredient, ResourceKey<Gene> gene, float chance, boolean mutation, RegistryAccess registryAccess) {
        DeferredHolder requiredPotion = mutation ? ModPotions.INSTANCE.getMUTATION() : ModPotions.INSTANCE.getCELL_GROWTH();
        ItemStack potionStack = PotionContents.createItemStack((Item)Items.POTION, (Holder)requiredPotion);
        EntityDnaItem.Companion.setEntityType(potionStack, entityType);
        this.input = Ingredient.of((ItemStack[])new ItemStack[]{potionStack});
        ItemStack gmoStack = ModItems.INSTANCE.getGMO_CELL().toStack();
        EntityDnaItem.Companion.setEntityType(gmoStack, entityType);
        DnaHelixItem.Companion.setGeneHolder(gmoStack, (Holder)ModGenes.INSTANCE.getHolderOrThrow(gene, (HolderLookup.Provider)registryAccess));
        this.goodOutput = gmoStack;
        ItemStack failCell = ModItems.INSTANCE.getGMO_CELL().toStack();
        EntityDnaItem.Companion.setEntityType(failCell, entityType);
        DnaHelixItem.Companion.setGeneHolder(failCell, (Holder)ModGenes.INSTANCE.getHolderOrThrow(ModGenes.INSTANCE.getBASIC(), (HolderLookup.Provider)registryAccess));
        this.badOutput = failCell;
        this.ingredient = ingredient;
        this.chance = chance;
    }

    public float getChance() {
        return this.chance;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getBadOutput() {
        return this.badOutput;
    }

    public ItemStack getGoodOutput() {
        return this.goodOutput;
    }

    public static List<GMORecipe> collectAllRecipes(RecipeManager recipeManager, RegistryAccess registryAccess) {
        ArrayList<GMORecipe> recipes = new ArrayList<GMORecipe>();
        for (RecipeHolder gmoRecipe : GmoRecipe.Companion.getGmoRecipes(recipeManager)) {
            GmoRecipe value = (GmoRecipe)gmoRecipe.value();
            recipes.add(new GMORecipe(value.getEntityType(), value.getTopIngredient(), (ResourceKey<Gene>)value.getIdealGeneRk(), value.getGeneChance(), value.getNeedsMutationPotion(), registryAccess));
        }
        return recipes;
    }
}

