/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.cell;

import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.core.AEConfig;
import appeng.core.localization.Tooltips;
import appeng.items.storage.StorageCellTooltipComponent;
import com.glodblock.github.appflux.api.IFluxCell;
import com.glodblock.github.appflux.common.me.cell.FECellInventory;
import com.glodblock.github.appflux.common.me.cell.FluxCellInventory;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FECellHandler
implements ICellHandler {
    public static final FECellHandler HANDLER = new FECellHandler();

    public boolean isCell(ItemStack is) {
        IFluxCell cell;
        Item item;
        return !is.isEmpty() && (item = is.getItem()) instanceof IFluxCell && (cell = (IFluxCell)item).getEnergyType() == EnergyType.FE;
    }

    @Nullable
    public FluxCellInventory getCellInventory(ItemStack is, @Nullable ISaveProvider host) {
        if (this.isCell(is)) {
            return new FECellInventory((IFluxCell)is.getItem(), is, host);
        }
        return null;
    }

    public void addCellInformationToTooltip(ItemStack is, List<Component> lines) {
        FluxCellInventory handler = this.getCellInventory(is, null);
        if (handler == null) {
            return;
        }
        lines.add(Tooltips.bytesUsed((long)handler.getUsedBytes(), (long)handler.getTotalBytes()));
        lines.add((Component)Component.translatable((String)"appflux.cell.storage", (Object[])new Object[]{Tooltips.ofNumber((long)handler.storedEnergy), handler.getEnergyType().translate()}));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack is) {
        FluxCellInventory handler = this.getCellInventory(is, null);
        if (handler == null) {
            return Optional.empty();
        }
        ArrayList<ItemStack> upgradeStacks = new ArrayList<ItemStack>();
        if (AEConfig.instance().isTooltipShowCellUpgrades()) {
            for (ItemStack upgrade : handler.getUpgrades()) {
                upgradeStacks.add(upgrade);
            }
        }
        return Optional.of(new StorageCellTooltipComponent(upgradeStacks, List.of(), false, true));
    }
}

