/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.util.SpacerTextComponent;
import com.ldtteam.blockui.util.ToggleableTextComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public abstract class AbstractTextElement
extends Pane {
    public static final float FILTERING_MAX_SCALE = 2.0f;
    public static final float FILTERING_THRESHOLD = 0.02f;
    public static final double DEFAULT_TEXT_SCALE = 1.0;
    public static final Alignment DEFAULT_TEXT_ALIGNMENT = Alignment.MIDDLE_LEFT;
    public static final int DEFAULT_TEXT_COLOR = 0xFFFFFF;
    public static final boolean DEFAULT_TEXT_SHADOW = false;
    public static final boolean DEFAULT_TEXT_WRAP = false;
    public static final int DEFAULT_TEXT_LINESPACE = 0;
    public static final int SIZE_FOR_UNLIMITED_ELEMENTS = 1000000;
    protected double textScale = 1.0;
    protected Alignment textAlignment = DEFAULT_TEXT_ALIGNMENT;
    protected int textColor = 0xFFFFFF;
    protected int textHoverColor = 0xFFFFFF;
    protected int textDisabledColor = 0xFFFFFF;
    protected boolean textShadow = false;
    protected boolean textWrap = false;
    protected int textLinespace = 0;
    protected List<MutableComponent> text;
    protected List<FormattedCharSequence> preparedText;
    protected int renderedTextWidth;
    protected int renderedTextHeight;
    protected int textOffsetX = 0;
    protected int textOffsetY = 0;
    protected int textWidth = this.width;
    protected int textHeight = this.height;

    public AbstractTextElement() {
        this(DEFAULT_TEXT_ALIGNMENT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
    }

    public AbstractTextElement(Alignment defaultTextAlignment, int defaultTextColor, int defaultTextHoverColor, int defaultTextDisabledColor, boolean defaultTextShadow, boolean defaultTextWrap) {
        this.textAlignment = defaultTextAlignment;
        this.textColor = defaultTextColor;
        this.textHoverColor = defaultTextHoverColor;
        this.textDisabledColor = defaultTextDisabledColor;
        this.textShadow = defaultTextShadow;
        this.textWrap = defaultTextWrap;
    }

    public AbstractTextElement(PaneParams params) {
        this(params, DEFAULT_TEXT_ALIGNMENT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
    }

    public AbstractTextElement(PaneParams params, Alignment defaultTextAlignment, int defaultTextColor, int defaultTextHoverColor, int defaultTextDisabledColor, boolean defaultTextShadow, boolean defaultTextWrap) {
        super(params);
        this.textAlignment = params.getEnum("textalign", Alignment.class, defaultTextAlignment);
        if (params.hasAttribute("color")) {
            this.setColors(params.getColor("color", defaultTextColor));
        } else {
            this.textColor = params.getColor("textcolor", defaultTextColor);
            this.textHoverColor = params.getColor("texthovercolor", defaultTextHoverColor);
            this.textDisabledColor = params.getColor("textdisabledcolor", defaultTextDisabledColor);
        }
        this.textShadow = params.getBoolean("shadow", defaultTextShadow);
        this.textWrap = params.getBoolean("wrap", defaultTextWrap);
        this.textScale = params.getDouble("textscale", this.textScale);
        this.textLinespace = params.getInteger("linespace", this.textLinespace);
        this.text = params.getMultilineText(params.hasAnyAttribute("label", "text"));
    }

    protected void recalcTextRendering() {
        if (this.textScale <= 0.0 || this.textWidth < 1 || this.textHeight < 1 || this.isTextEmpty()) {
            this.preparedText = Collections.emptyList();
            return;
        }
        int maxWidth = (int)((double)this.textWidth / this.textScale) - (this.textShadow ? 1 : 0);
        this.preparedText = this.text.stream().flatMap(textBlock -> this.toFormattedSequence(maxWidth, (MutableComponent)textBlock)).collect(Collectors.toList());
    }

    private Stream<? extends FormattedCharSequence> toFormattedSequence(int maxWidth, MutableComponent textBlock) {
        ComponentContents componentContents = textBlock.getContents();
        if (componentContents instanceof SpacerTextComponent) {
            SpacerTextComponent spacer = (SpacerTextComponent)componentContents;
            return Stream.of(spacer.getVisualOrderText());
        }
        componentContents = textBlock.getContents();
        if (componentContents instanceof ToggleableTextComponent) {
            ToggleableTextComponent toggleable = (ToggleableTextComponent)componentContents;
            return this.toFormattedSequence(maxWidth, toggleable.data()).map(formatted -> new ToggleableTextComponent.FormattedToggleableCharSequence(toggleable.condition(), (FormattedCharSequence)formatted));
        }
        if (textBlock.getContents() == Component.empty().getContents() && textBlock.getSiblings().isEmpty()) {
            return Stream.of(textBlock.getVisualOrderText());
        }
        return this.mc.font.split((FormattedText)textBlock, maxWidth).stream();
    }

    public void recalcPreparedTextBox() {
        if (this.textWrap) {
            int maxHeight = (int)((double)this.textHeight / this.textScale) + 1;
            Objects.requireNonNull(this.mc.font);
            int lineHeight = 9 + this.textLinespace;
            this.preparedText = this.preparedText.subList(0, Math.min(this.preparedText.size(), maxHeight / lineHeight));
            int heightSum = 0;
            int widthMax = 0;
            for (FormattedCharSequence textBlock : this.preparedText) {
                if (textBlock instanceof SpacerTextComponent.FormattedSpacerComponent) {
                    SpacerTextComponent.FormattedSpacerComponent spacer = (SpacerTextComponent.FormattedSpacerComponent)textBlock;
                    heightSum += spacer.pixelHeight() + this.textLinespace;
                    continue;
                }
                if (textBlock instanceof ToggleableTextComponent.FormattedToggleableCharSequence) {
                    ToggleableTextComponent.FormattedToggleableCharSequence toggleable = (ToggleableTextComponent.FormattedToggleableCharSequence)textBlock;
                    if (!toggleable.condition().getAsBoolean()) continue;
                    heightSum += lineHeight;
                    widthMax = Math.max(widthMax, this.mc.font.width(toggleable.data()));
                    continue;
                }
                heightSum += lineHeight;
                widthMax = Math.max(widthMax, this.mc.font.width(textBlock));
            }
            this.renderedTextWidth = (int)((double)widthMax * this.textScale);
            this.renderedTextHeight = (int)((double)(Math.min(heightSum, maxHeight) - 1 - this.textLinespace) * this.textScale);
        } else {
            this.preparedText = this.preparedText.subList(0, 1);
            this.renderedTextWidth = (int)((double)this.mc.font.width(this.preparedText.get(0)) * this.textScale);
            Objects.requireNonNull(this.mc.font);
            this.renderedTextHeight = (int)((double)(9 - 1) * this.textScale);
        }
    }

    @Override
    public void drawSelf(BOGuiGraphics ms, double mx, double my) {
        if (!this.preparedText.isEmpty()) {
            this.recalcPreparedTextBox();
            this.innerDrawSelf(ms, mx, my);
        }
    }

    protected void innerDrawSelf(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.pose();
        int color = this.isEnabled() ? (this.wasCursorInPane ? this.textHoverColor : this.textColor) : this.textDisabledColor;
        int offsetX = this.textOffsetX;
        int offsetY = this.textOffsetY;
        if (this.textAlignment.isRightAligned()) {
            offsetX += this.textWidth - this.renderedTextWidth;
        } else if (this.textAlignment.isHorizontalCentered()) {
            offsetX += (this.textWidth - this.renderedTextWidth) / 2;
        }
        if (this.textAlignment.isBottomAligned()) {
            offsetY += this.textHeight - this.renderedTextHeight;
        } else if (this.textAlignment.isVerticalCentered()) {
            offsetY += (this.textHeight - this.renderedTextHeight) / 2;
        }
        ms.pushPose();
        ms.translate((double)(this.x + offsetX), (double)(this.y + offsetY), 0.0);
        ms.scale((float)this.textScale, (float)this.textScale, 1.0f);
        Matrix4f matrix4f = ms.last().pose();
        int fbW = this.window.getScreen().getFramebufferWidth();
        int fbH = this.window.getScreen().getFramebufferHeight();
        Vector4f temp = new Vector4f(1.0f, 1.0f, 0.0f, 0.0f);
        matrix4f.transform(temp);
        temp.w = 1.0f;
        temp.mulProject((Matrix4fc)RenderSystem.getProjectionMatrix());
        temp.add(1.0f, 1.0f, 0.0f, 0.0f);
        temp.mul((float)fbW / 2.0f, (float)fbH / 2.0f, 0.0f, 0.0f);
        float scale = temp.distanceSquared(0.02f, (float)fbH - 0.02f, 0.0f, 0.0f);
        NeoForgeRenderTypes.enableTextTextureLinearFiltering = Math.abs(temp.x - (float)fbH + temp.y) > 0.02f || scale < 4.0f;
        MultiBufferSource.BufferSource drawBuffer = target.bufferSource();
        int lineShift = 0;
        for (FormattedCharSequence row : this.preparedText) {
            if (row == FormattedCharSequence.EMPTY) {
                Objects.requireNonNull(this.mc.font);
                lineShift += 9 + this.textLinespace;
                continue;
            }
            if (row instanceof ToggleableTextComponent.FormattedToggleableCharSequence) {
                ToggleableTextComponent.FormattedToggleableCharSequence toggleable = (ToggleableTextComponent.FormattedToggleableCharSequence)row;
                if (!toggleable.condition().getAsBoolean()) continue;
                row = toggleable.data();
            } else if (row instanceof SpacerTextComponent.FormattedSpacerComponent) {
                SpacerTextComponent.FormattedSpacerComponent spacer = (SpacerTextComponent.FormattedSpacerComponent)row;
                lineShift += spacer.pixelHeight() + this.textLinespace;
                continue;
            }
            int xOffset = this.textAlignment.isRightAligned() ? (int)(((double)this.renderedTextWidth - (double)this.mc.font.width(row) * this.textScale) / this.textScale) : (this.textAlignment.isHorizontalCentered() ? (int)(((double)this.renderedTextWidth - (double)this.mc.font.width(row) * this.textScale) / 2.0 / this.textScale) : 0);
            this.mc.font.drawInBatch(row, (float)xOffset, (float)lineShift, color, this.textShadow, matrix4f, (MultiBufferSource)drawBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            Objects.requireNonNull(this.mc.font);
            lineShift += 9 + this.textLinespace;
        }
        drawBuffer.endBatch();
        NeoForgeRenderTypes.enableTextTextureLinearFiltering = false;
        RenderSystem.disableBlend();
        ms.popPose();
    }

    public Alignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public double getTextScale() {
        return this.textScale;
    }

    public void setTextScale(double textScale) {
        this.textScale = textScale;
        this.recalcTextRendering();
    }

    public void setColors(int color) {
        this.setColors(color, color, color);
    }

    public void setColors(int textColor, int textDisabledColor, int textHoverColor) {
        this.textColor = textColor;
        this.textDisabledColor = textDisabledColor;
        this.textHoverColor = textHoverColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getTextHoverColor() {
        return this.textHoverColor;
    }

    public void setTextHoverColor(int textHoverColor) {
        this.textHoverColor = textHoverColor;
    }

    public int getTextDisabledColor() {
        return this.textDisabledColor;
    }

    public void setTextDisabledColor(int textDisabledColor) {
        this.textDisabledColor = textDisabledColor;
    }

    public int getTextLinespace() {
        return this.textLinespace;
    }

    public void setTextLinespace(int textLinespace) {
        this.textLinespace = textLinespace;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public boolean isTextWrap() {
        return this.textWrap;
    }

    public void setTextWrap(boolean textWrap) {
        this.textWrap = textWrap;
        this.recalcTextRendering();
    }

    @Nullable
    public List<MutableComponent> getTextAsList() {
        return this.text;
    }

    @Nullable
    public MutableComponent getText() {
        return this.isTextEmpty() ? null : this.text.get(0);
    }

    public void setTextOld(List<Component> text) {
        this.setText(text.stream().map(c -> {
            MutableComponent m;
            return c instanceof MutableComponent ? (m = (MutableComponent)c) : c.copy();
        }).toList());
    }

    public void setText(List<MutableComponent> text) {
        this.text = text;
        this.recalcTextRendering();
    }

    public void setText(Component text) {
        MutableComponent m;
        this.setText(text instanceof MutableComponent ? (m = (MutableComponent)text) : text.copy());
    }

    public void setText(MutableComponent text) {
        this.setText(Collections.singletonList(text));
    }

    public void clearText() {
        this.setText(Collections.emptyList());
    }

    @Nullable
    public String getTextAsStringStrict() {
        return this.isTextEmpty() ? null : this.text.get(0).getString();
    }

    public String getTextAsString() {
        return this.isTextEmpty() ? "" : this.text.get(0).getString();
    }

    public boolean isTextEmpty() {
        return this.text == null || this.text.stream().allMatch(t -> t.getString().isEmpty());
    }

    public int getRenderedTextWidth() {
        return this.renderedTextWidth;
    }

    public int getRenderedTextHeight() {
        return this.renderedTextHeight;
    }

    public List<FormattedCharSequence> getPreparedText() {
        return this.preparedText;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.setTextSize(w, h);
    }

    public void setTextSize(int w, int h) {
        this.textWidth = this.width;
        this.textHeight = this.height;
        this.recalcTextRendering();
    }
}

