/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.UiRenderMacros;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLEnvironment;

public class CheckBox
extends ButtonImage {
    protected ResourceLocation checkmarkImage;
    protected UiRenderMacros.ResolvedBlit resolvedCheckmarkImage;
    private boolean checked = false;

    public CheckBox() {
    }

    public CheckBox(PaneParams params) {
        super(params);
        this.checkmarkImage = params.getResource("checkmark");
    }

    @Override
    public boolean handleClick(double mx, double my) {
        this.checked = !this.checked;
        super.handleClick(mx, my);
        return true;
    }

    public void setCheckmarkImage(ResourceLocation loc) {
        this.checkmarkImage = loc;
    }

    public ResourceLocation getCheckmarkImage() {
        return this.checkmarkImage;
    }

    @Override
    public void postDrawBackground(BOGuiGraphics target, double mx, double my) {
        if (!FMLEnvironment.production) {
            Objects.requireNonNull(this.checkmarkImage, () -> "Missing checkmark source: " + this.id + " | " + String.valueOf(this.window.getXmlResourceLocation()));
        }
        if (!this.checked) {
            return;
        }
        if (this.resolvedCheckmarkImage == null) {
            this.resolvedCheckmarkImage = Image.resolveBlit(this.checkmarkImage);
        }
        this.resolvedCheckmarkImage.blit(target.pose(), this.x, this.y, this.width, this.height);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }
}

