/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.util;

import com.ldtteam.common.fakelevel.SingleBlockFakeLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.Nullable;

public class BlockToItemHelper {
    public static final HitResult ZERO_POS_HIT_RESULT = new BlockHitResult(Vec3.atCenterOf((Vec3i)BlockPos.ZERO), Direction.NORTH, BlockPos.ZERO, true);
    private static final SingleBlockFakeLevel.SidedSingleBlockFakeLevel fakeLevel = new SingleBlockFakeLevel.SidedSingleBlockFakeLevel();

    public static ItemStack getItemStack(BlockState blockState, BlockEntity blockEntity, Player player) {
        if (blockState.getBlock() instanceof AirBlock) {
            return ItemStack.EMPTY;
        }
        return fakeLevel.get(player.level()).useFakeLevelContext(blockState, blockEntity, player.level(), level -> BlockToItemHelper.getItemStackUsingPlayerPick(level, BlockPos.ZERO, player, ZERO_POS_HIT_RESULT));
    }

    public static ItemStack getItemStack(ServerLevel serverLevel, BlockPos pos) {
        return BlockToItemHelper.getItemStack((Level)serverLevel, pos, (Player)FakePlayerFactory.getMinecraft((ServerLevel)serverLevel));
    }

    public static ItemStack getItemStack(Level level, BlockPos pos, Player player) {
        return BlockToItemHelper.getItemStackUsingPlayerPick(level, pos, player, null);
    }

    public static ItemStack getItemStackUsingPlayerPick(Level level, BlockPos pos, Player player, @Nullable HitResult hitResult) {
        BlockState blockState;
        ItemStack result;
        if (hitResult == null) {
            hitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.NORTH, pos, true);
        }
        if ((result = (blockState = level.getBlockState(pos)).getCloneItemStack(hitResult, (LevelReader)level, pos, player)).isEmpty()) {
            result = BlockToItemHelper.getItem(blockState).getDefaultInstance();
        }
        return result;
    }

    public static Item getItem(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquid = (LiquidBlock)block;
            return liquid.fluid.getBucket();
        }
        if (block instanceof BubbleColumnBlock) {
            return Fluids.WATER.getBucket();
        }
        if (block instanceof BaseFireBlock) {
            return Items.FLINT_AND_STEEL;
        }
        return block.asItem();
    }
}

