/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client;

import com.direwolf20.mininggadgets.client.OurKeys;
import com.direwolf20.mininggadgets.client.renderer.BlockOverlayRender;
import com.direwolf20.mininggadgets.client.renderer.ModificationShiftOverlay;
import com.direwolf20.mininggadgets.client.renderer.RenderMiningLaser;
import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class ClientEvents {
    @SubscribeEvent
    static void drawBlockHighlightEvent(RenderHighlightEvent.Block evt) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (MiningGadget.isHolding((Player)Minecraft.getInstance().player)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void renderWorldLastEvent(RenderLevelStageEvent evt) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        List players = Minecraft.getInstance().level.players();
        LocalPlayer myplayer = Minecraft.getInstance().player;
        ItemStack myItem = MiningGadget.getGadget((Player)myplayer);
        if (myItem.getItem() instanceof MiningGadget) {
            BlockOverlayRender.render(evt, myItem);
        }
        if (myplayer.isShiftKeyDown()) {
            ModificationShiftOverlay.render(evt, (Player)myplayer);
        }
        for (Player player : players) {
            if (player.distanceToSqr((Entity)myplayer) > 500.0) continue;
            ItemStack heldItem = MiningGadget.getGadget(player);
            if (!player.isUsingItem() || !(heldItem.getItem() instanceof MiningGadget) || !MiningGadget.canMine(heldItem)) continue;
            RenderMiningLaser.renderLaser(evt, player, evt.getPartialTick().getGameTimeDeltaPartialTick(false));
        }
    }

    @SubscribeEvent
    static void keyPressed(InputEvent.Key event) {
        if (OurKeys.shiftClickGuiBinding.consumeClick() && Minecraft.getInstance().screen == null) {
            if (Minecraft.getInstance().player == null) {
                return;
            }
            ItemStack gadget = MiningGadget.getGadget((Player)Minecraft.getInstance().player);
            if (gadget.isEmpty()) {
                return;
            }
            ModScreens.openGadgetSettingsScreen(gadget);
        }
    }
}

