/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client;

import com.direwolf20.mininggadgets.client.screens.ModificationTableScreen;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.setup.Config;
import com.direwolf20.mininggadgets.setup.MGDataComponents;
import com.direwolf20.mininggadgets.setup.Registration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

@MethodsReturnNonnullByDefault
@JeiPlugin
public class MiningGadgetsJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"mininggadgets", (String)"jei_plugin");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        IIngredientSubtypeInterpreter chargedProvider = (stack, uid) -> {
            if (!(stack.getItem() instanceof MiningGadget)) {
                return "";
            }
            int energy = (Integer)stack.getOrDefault(MGDataComponents.FORGE_ENERGY, (Object)0);
            if (energy == 0) {
                return "empty";
            }
            if (energy == (Integer)Config.MININGGADGET_MAXPOWER.get()) {
                return "charged";
            }
            return "";
        };
        registration.registerSubtypeInterpreter((Item)Registration.MININGGADGET.get(), chargedProvider);
        registration.registerSubtypeInterpreter((Item)Registration.MININGGADGET_SIMPLE.get(), chargedProvider);
        registration.registerSubtypeInterpreter((Item)Registration.MININGGADGET_FANCY.get(), chargedProvider);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(ModificationTableScreen.class, (IGuiContainerHandler)new ModificationTableContainerHandler());
    }

    private static class ModificationTableContainerHandler
    implements IGuiContainerHandler<ModificationTableScreen> {
        private ModificationTableContainerHandler() {
        }

        public List<Rect2i> getGuiExtraAreas(ModificationTableScreen containerScreen) {
            return new ArrayList<Rect2i>(Collections.singleton(new Rect2i(containerScreen.width / 2 - 120, containerScreen.height / 2 - 5, 25, 35)));
        }
    }
}

