/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import com.direwolf20.mininggadgets.setup.Registration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ModificationTableTER
implements BlockEntityRenderer<ModificationTableTileEntity> {
    public ModificationTableTER(BlockEntityRendererProvider.Context p_173636_) {
    }

    public void render(ModificationTableTileEntity tile, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLights, int combinedOverlay) {
        float leftModifier;
        IItemHandler cap = (IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), (BlockEntity)tile, null);
        if (cap == null) {
            return;
        }
        ItemStack stack = cap.getStackInSlot(0);
        if (stack.isEmpty()) {
            return;
        }
        boolean isSimple = stack.getItem().equals(Registration.MININGGADGET_SIMPLE.get());
        boolean isFancy = stack.getItem().equals(Registration.MININGGADGET_FANCY.get());
        boolean isCool = !isSimple && !isFancy;
        Direction facing = (Direction)tile.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        matrix.pushPose();
        matrix.translate(0.0f, 0.81f, 0.0f);
        float f = isCool ? 0.0f : (leftModifier = isFancy ? 0.15f : 0.2f);
        if (facing == Direction.SOUTH) {
            matrix.translate(0.7f - leftModifier, 0.0f, 0.85f);
            matrix.mulPose(Axis.YP.rotationDegrees(90.0f));
        } else if (facing == Direction.EAST) {
            matrix.translate(0.85f, 0.0f, 0.3f + leftModifier);
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
        } else if (facing == Direction.NORTH) {
            matrix.translate(0.3f + leftModifier, 0.0f, 0.15f);
            matrix.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else {
            matrix.translate(0.15f, 0.0f, 0.7f - leftModifier);
        }
        matrix.mulPose(Axis.ZN.rotationDegrees(90.0f));
        if (isCool) {
            matrix.scale(0.65f, 0.65f, 0.65f);
        } else {
            matrix.scale(0.8f, 0.8f, 0.8f);
        }
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
        Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.FIRST_PERSON_LEFT_HAND, false, matrix, buffer, combinedLights, combinedOverlay, model);
        matrix.popPose();
    }
}

