/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.network.data.ExtractUpgradePayload;
import com.direwolf20.mininggadgets.common.network.data.InsertUpgradePayload;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import net.neoforged.neoforge.network.PacketDistributor;

public class ModificationTableScreen
extends AbstractContainerScreen<ModificationTableContainer> {
    private ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"mininggadgets", (String)"textures/gui/modificationtable.png");
    private BlockPos tePos;
    private ModificationTableContainer container;
    private Inventory playerInventory;
    private ScrollingUpgrades scrollingUpgrades;

    public ModificationTableScreen(ModificationTableContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tePos = container.getTE().getBlockPos();
        this.container = container;
        this.playerInventory = inv;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.scrollingUpgrades.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int relX = this.width / 2;
        int relY = this.height / 2;
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"mininggadgets.text.modification_table"), relX, relY - 100, 0xFFFFFF);
        if (this.container.getUpgradesCache().size() == 0) {
            String string = Component.translatable((String)"mininggadgets.text.modification_table").getString();
            String[] parts = string.split("\n");
            for (int i = 0; i < parts.length; ++i) {
                int n = relX + 17 - this.font.width(parts[0]) / 2;
                Objects.requireNonNull(this.font);
                this.drawScaledCenteredString(guiGraphics, n, relY - 68 + i * 9, 0.8f, parts[i], 0xFFFFFF);
            }
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private void drawScaledCenteredString(GuiGraphics guiGraphics, int x, int y, float scale, String textComponent, int color) {
        PoseStack matrices = guiGraphics.pose();
        matrices.pushPose();
        matrices.translate((float)x, (float)y, 0.0f);
        matrices.scale(scale, scale, scale);
        guiGraphics.drawString(this.font, textComponent, 0, 0, color);
        matrices.popPose();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX - 23, relY, 0, 0, this.imageWidth + 23, this.imageHeight);
    }

    public void init() {
        super.init();
        this.scrollingUpgrades = new ScrollingUpgrades(Minecraft.getInstance(), this.imageWidth - 14, 72, this.topPos + 7, this.leftPos + 7, this);
        this.addRenderableWidget((GuiEventListener)this.scrollingUpgrades);
    }

    public boolean mouseClicked(double mouseXIn, double mouseYIn, int p_231044_5_) {
        ItemStack heldStack = ((ModificationTableContainer)this.menu).getCarried();
        ItemStack gadget = ((Slot)this.container.slots.get(0)).getItem();
        if (!gadget.isEmpty() && gadget.getItem() instanceof MiningGadget && !heldStack.isEmpty() && heldStack.getItem() instanceof UpgradeCard && this.scrollingUpgrades.isMouseOver(mouseXIn, mouseYIn)) {
            if (UpgradeTools.containsUpgrade(gadget, ((UpgradeCard)heldStack.getItem()).getUpgrade())) {
                return false;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new InsertUpgradePayload(this.tePos, heldStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((ModificationTableContainer)this.menu).setCarried(ItemStack.EMPTY);
        }
        return super.mouseClicked(mouseXIn, mouseYIn, p_231044_5_);
    }

    private static class ScrollingUpgrades
    extends ScrollPanel
    implements NarratableEntry {
        ModificationTableScreen parent;
        Upgrade upgrade = null;

        ScrollingUpgrades(Minecraft client, int width, int height, int top, int left, ModificationTableScreen parent) {
            super(client, width, height, top, left);
            this.parent = parent;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scroll, double scrollY) {
            if (this.getContentHeight() < this.height) {
                return false;
            }
            return super.mouseScrolled(mouseX, mouseY, scroll, scrollY);
        }

        protected int getContentHeight() {
            return (int)Math.ceil((float)this.parent.container.getUpgradesCache().size() / 7.0f) * 20;
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            Enum currentUpgrade = null;
            int x = entryRight - this.width + 3;
            int y = relativeY;
            int index = 0;
            for (Upgrade upgrade : this.parent.container.getUpgradesCache()) {
                guiGraphics.renderItem(new ItemStack((ItemLike)upgrade.getCardItem().get()), x, y);
                if (this.isMouseOver(mouseX, mouseY) && mouseX > x && mouseX < x + 15 && mouseY > y && mouseY < y + 15) {
                    currentUpgrade = upgrade;
                }
                x += 22;
                if (++index % 7 != 0) continue;
                y += 20;
                x = entryRight - this.width + 3;
            }
            if (currentUpgrade == null || !currentUpgrade.equals((Object)this.upgrade)) {
                this.upgrade = currentUpgrade;
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.isMouseOver(mouseX, mouseY) || this.upgrade == null) {
                return false;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ExtractUpgradePayload(this.parent.tePos, this.upgrade.getName(), this.upgrade.getName().length()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.upgrade != null) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, Lists.transform((List)new ItemStack((ItemLike)this.upgrade.getCardItem().get()).getTooltipLines(Item.TooltipContext.EMPTY, (Player)this.parent.getMinecraft().player, (TooltipFlag)TooltipFlag.Default.NORMAL), Component::getVisualOrderText), mouseX, mouseY);
            }
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput p_169152_) {
        }
    }
}

