/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.blocks;

import com.direwolf20.mininggadgets.setup.Registration;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ModificationTable
extends Block
implements EntityBlock {
    public static DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public ModificationTable() {
        super(BlockBehaviour.Properties.of().strength(2.0f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shape.getFromFacing((Direction)state.getValue((Property)FACING));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return ((BlockEntityType)Registration.MODIFICATIONTABLE_TILE.get()).create(p_153215_, p_153216_);
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            BlockEntity tileEntity = level.getBlockEntity(blockPos);
            if (!(tileEntity instanceof MenuProvider)) {
                throw new IllegalStateException("Our named container provider is missing!");
            }
            player.openMenu((MenuProvider)tileEntity, tileEntity.getBlockPos());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (newState.getBlock() != this && (tile = worldIn.getBlockEntity(pos)) != null) {
            IItemHandler cap = (IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, null);
            if (cap == null) {
                return;
            }
            for (int i = 0; i < cap.getSlots(); ++i) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)cap.getStackInSlot(i));
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    private static enum Shape {
        NORTH(Stream.of(Block.box((double)2.0, (double)11.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)9.0), Block.box((double)0.0, (double)10.0, (double)11.0, (double)16.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)10.0), Block.box((double)13.0, (double)12.0, (double)2.0, (double)14.0, (double)13.0, (double)8.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()),
        EAST(Stream.of(Block.box((double)0.0, (double)11.0, (double)2.0, (double)4.0, (double)16.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)7.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), Block.box((double)0.0, (double)10.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0), Block.box((double)6.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)8.0, (double)12.0, (double)13.0, (double)14.0, (double)13.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()),
        SOUTH(Stream.of(Block.box((double)2.0, (double)11.0, (double)0.0, (double)14.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)1.0, (double)10.0, (double)7.0, (double)15.0, (double)11.0, (double)15.0), Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)5.0), Block.box((double)0.0, (double)11.0, (double)6.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)2.0, (double)12.0, (double)8.0, (double)3.0, (double)13.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()),
        WEST(Stream.of(Block.box((double)12.0, (double)11.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)1.0, (double)10.0, (double)1.0, (double)9.0, (double)11.0, (double)15.0), Block.box((double)11.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0), Block.box((double)2.0, (double)12.0, (double)2.0, (double)8.0, (double)13.0, (double)3.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get());

        private final VoxelShape shape;

        private Shape(VoxelShape shape) {
            this.shape = shape;
        }

        public static VoxelShape getFromFacing(Direction facing) {
            return switch (facing) {
                case Direction.NORTH -> Shape.NORTH.shape;
                case Direction.EAST -> Shape.EAST.shape;
                case Direction.SOUTH -> Shape.SOUTH.shape;
                case Direction.WEST -> Shape.WEST.shape;
                default -> throw new IllegalStateException("Invalid facing");
            };
        }
    }
}

