/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.tiles;

import com.direwolf20.mininggadgets.client.particles.laserparticle.LaserParticleData;
import com.direwolf20.mininggadgets.common.events.ServerTickHandler;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.util.SpecialBlockActions;
import com.direwolf20.mininggadgets.setup.Config;
import com.direwolf20.mininggadgets.setup.Registration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class RenderBlockTileEntity
extends BlockEntity {
    private final Random rand = new Random();
    private BlockState renderBlock;
    private int priorDurability = 9999;
    private int clientPrevDurability;
    private int clientDurability;
    private int durability;
    private UUID playerUUID;
    private int originalDurability;
    private int ticksSinceMine = 0;
    private List<Upgrade> gadgetUpgrades = new ArrayList<Upgrade>();
    private List<ItemStack> gadgetFilters;
    private boolean gadgetIsWhitelist;
    private boolean packetReceived = false;
    private int totalAge;
    private MiningProperties.BreakTypes breakType;
    private boolean blockAllowed;

    public RenderBlockTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.RENDERBLOCK_TILE.get(), pos, state);
    }

    public static boolean blockAllowed(List<ItemStack> drops, List<ItemStack> filters, boolean isWhiteList) {
        boolean blockAllowed = false;
        for (ItemStack dropStack : drops) {
            if (filters.size() == 0) {
                return true;
            }
            boolean contains = false;
            for (ItemStack filter : filters) {
                if (!ItemStack.matches((ItemStack)dropStack, (ItemStack)filter)) continue;
                contains = true;
                break;
            }
            if (!(blockAllowed = isWhiteList && contains || !isWhiteList && !contains)) continue;
            break;
        }
        return blockAllowed;
    }

    public static <T extends BlockEntity> void ticker(Level level, BlockPos blockPos, BlockState state, T tile) {
        if (!(tile instanceof RenderBlockTileEntity)) {
            return;
        }
        RenderBlockTileEntity entity = (RenderBlockTileEntity)tile;
        ++entity.totalAge;
        if (entity.ticksSinceMine == 0) {
            entity.spawnParticle();
        }
        if (entity.level.isClientSide) {
            if (entity.playerUUID != null) {
                entity.ticksSinceMine = entity.getPlayer() != null && !entity.getPlayer().isUsingItem() ? ++entity.ticksSinceMine : 0;
            }
            if (entity.packetReceived) {
                entity.priorDurability = entity.durability;
                entity.durability = entity.clientDurability;
                entity.packetReceived = false;
            } else if (entity.durability != 0) {
                entity.priorDurability = entity.durability;
            }
        }
        if (!entity.level.isClientSide) {
            if (entity.ticksSinceMine == 1) {
                entity.priorDurability = entity.durability;
                ServerTickHandler.addToList(blockPos, entity.durability, level);
            }
            if (entity.ticksSinceMine >= 10) {
                entity.priorDurability = entity.durability++;
                ServerTickHandler.addToList(blockPos, entity.durability, level);
            }
            if (entity.durability >= entity.originalDurability) {
                entity.resetBlock();
            }
            ++entity.ticksSinceMine;
        }
    }

    public BlockState getRenderBlock() {
        if (this.renderBlock == null) {
            return Blocks.COBBLESTONE.defaultBlockState();
        }
        return this.renderBlock;
    }

    public void setRenderBlock(BlockState state) {
        this.renderBlock = state;
    }

    public MiningProperties.BreakTypes getBreakType() {
        return this.breakType;
    }

    public void setBreakType(MiningProperties.BreakTypes breakType) {
        this.breakType = breakType;
    }

    public void justSetDurability(int durability) {
        this.priorDurability = this.durability;
        this.durability = durability;
    }

    public void setDurability(int dur, ItemStack stack) {
        this.ticksSinceMine = 0;
        if (this.durability != 0) {
            this.priorDurability = this.durability;
        }
        this.durability = dur;
        if (dur <= 0) {
            this.removeBlock();
            if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.FREEZING)) {
                this.freeze(stack);
            }
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            ServerTickHandler.addToList(this.worldPosition, this.durability, this.level);
        }
    }

    private void freeze(ItemStack stack) {
        int freezeCost = (Integer)Config.UPGRADECOST_FREEZE.get() * -1;
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap == null) {
            return;
        }
        int energy = cap.getEnergyStored();
        if (energy == 0) {
            return;
        }
        for (Direction side : Direction.values()) {
            BlockPos sidePos = this.worldPosition.relative(side);
            FluidState state = this.level.getFluidState(sidePos);
            if (state.getType().isSame((Fluid)Fluids.LAVA) && state.getType().isSource(state)) {
                energy -= this.replaceBlockWithAlternative(this.level, sidePos, Blocks.OBSIDIAN.defaultBlockState(), stack, freezeCost, energy);
                continue;
            }
            if (state.getType().isSame((Fluid)Fluids.WATER) && state.getType().isSource(state)) {
                energy -= this.replaceBlockWithAlternative(this.level, sidePos, Blocks.PACKED_ICE.defaultBlockState(), stack, freezeCost, energy);
                continue;
            }
            if (!state.getType().isSame((Fluid)Fluids.WATER) && !state.getType().isSame((Fluid)Fluids.LAVA) || state.getType().isSource(state)) continue;
            energy -= this.replaceBlockWithAlternative(this.level, sidePos, Blocks.COBBLESTONE.defaultBlockState(), stack, freezeCost, energy);
        }
    }

    private int replaceBlockWithAlternative(Level world, BlockPos pos, BlockState state, ItemStack stack, int costOfOperation, int remainingEnergy) {
        if (remainingEnergy < costOfOperation) {
            return 0;
        }
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap == null) {
            return 0;
        }
        cap.receiveEnergy(costOfOperation, false);
        BlockState blockState = world.getBlockState(pos);
        if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            return costOfOperation;
        }
        if (world.getBlockEntity(pos) == null) {
            world.setBlockAndUpdate(pos, state);
            return costOfOperation;
        }
        return 0;
    }

    public void spawnParticle() {
        if (this.renderBlock == null || this.renderBlock.isAir()) {
            return;
        }
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.MAGNET) && this.originalDurability > 0) {
            int PartCount = 20 / this.originalDurability;
            if (PartCount <= 1) {
                PartCount = 1;
            }
            for (int i = 0; i <= PartCount; ++i) {
                double randomPartSize = 0.125 + this.rand.nextDouble() * 0.5;
                double randomX = this.rand.nextDouble();
                double randomY = this.rand.nextDouble();
                double randomZ = this.rand.nextDouble();
                LaserParticleData data = LaserParticleData.laserparticle(this.renderBlock, (float)randomPartSize, 200.0f);
                this.getLevel().addParticle((ParticleOptions)data, (double)this.getBlockPos().getX() + randomX, (double)this.getBlockPos().getY() + randomY, (double)this.getBlockPos().getZ() + randomZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getDurability() {
        return this.durability;
    }

    public int getOriginalDurability() {
        return this.originalDurability;
    }

    public void setOriginalDurability(int originalDurability) {
        this.originalDurability = originalDurability;
    }

    public Player getPlayer() {
        if (this.getLevel() == null) {
            return null;
        }
        return this.getLevel().getPlayerByUUID(this.playerUUID);
    }

    public void setPlayer(Player player) {
        this.playerUUID = player.getUUID();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public int getTicksSinceMine() {
        return this.ticksSinceMine;
    }

    public void setTicksSinceMine(int ticksSinceMine) {
        this.ticksSinceMine = ticksSinceMine;
    }

    public int getPriorDurability() {
        return this.priorDurability;
    }

    public void setPriorDurability(int priorDurability) {
        this.priorDurability = priorDurability;
    }

    public int getClientDurability() {
        return this.clientDurability;
    }

    public void setClientDurability(int clientDurability) {
        this.clientPrevDurability = this.durability == 0 ? clientDurability : this.durability;
        this.clientDurability = clientDurability;
        this.packetReceived = true;
    }

    public List<Upgrade> getGadgetUpgrades() {
        return this.gadgetUpgrades;
    }

    public void setGadgetUpgrades(List<Upgrade> gadgetUpgrades) {
        this.gadgetUpgrades = gadgetUpgrades;
    }

    public List<ItemStack> getGadgetFilters() {
        return this.gadgetFilters;
    }

    public void setGadgetFilters(List<ItemStack> gadgetFilters) {
        this.gadgetFilters = gadgetFilters;
    }

    public boolean isGadgetIsWhitelist() {
        return this.gadgetIsWhitelist;
    }

    public void setGadgetIsWhitelist(boolean gadgetIsWhitelist) {
        this.gadgetIsWhitelist = gadgetIsWhitelist;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public void markDirtyClient() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.renderBlock = NbtUtils.readBlockState((HolderGetter)this.level.holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("renderBlock"));
        this.originalDurability = tag.getInt("originalDurability");
        this.priorDurability = tag.getInt("priorDurability");
        this.durability = tag.getInt("durability");
        this.ticksSinceMine = tag.getInt("ticksSinceMine");
        if (tag.contains("playerUUID")) {
            this.playerUUID = tag.getUUID("playerUUID");
        }
        this.gadgetUpgrades = UpgradeTools.getUpgradesFromTag(tag);
        this.breakType = MiningProperties.BreakTypes.values()[tag.getByte("breakType")];
        this.gadgetFilters = MiningProperties.deserializeItemStackList(tag.getCompound("gadgetFilters"), provider);
        this.gadgetIsWhitelist = tag.getBoolean("gadgetIsWhitelist");
        this.blockAllowed = tag.getBoolean("blockAllowed");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.renderBlock != null) {
            tag.put("renderBlock", (Tag)NbtUtils.writeBlockState((BlockState)this.renderBlock));
        }
        tag.putInt("originalDurability", this.originalDurability);
        tag.putInt("priorDurability", this.priorDurability);
        tag.putInt("durability", this.durability);
        tag.putInt("ticksSinceMine", this.ticksSinceMine);
        if (this.playerUUID != null) {
            tag.putUUID("playerUUID", this.playerUUID);
        }
        tag.put("upgrades", (Tag)UpgradeTools.setUpgradesNBT(this.gadgetUpgrades).getList("upgrades", 10));
        tag.putByte("breakType", (byte)this.breakType.ordinal());
        tag.put("gadgetFilters", (Tag)MiningProperties.serializeItemStackList(this.getGadgetFilters(), provider));
        tag.putBoolean("gadgetIsWhitelist", this.isGadgetIsWhitelist());
        tag.putBoolean("blockAllowed", this.blockAllowed);
    }

    private void removeBlock() {
        Optional<Upgrade> upgrade;
        if (this.level == null || this.level.isClientSide || this.playerUUID == null) {
            return;
        }
        Player player = this.level.getPlayerByUUID(this.playerUUID);
        if (player == null) {
            return;
        }
        boolean silk = false;
        int fortune = 0;
        ItemStack tempTool = new ItemStack((ItemLike)Registration.MININGGADGET.get());
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.SILK)) {
            HolderLookup.RegistryLookup registrylookup = this.level.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            tempTool.enchant((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), 1);
            silk = true;
        }
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1) && (upgrade = UpgradeTools.getUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1)).isPresent()) {
            fortune = upgrade.get().getTier();
            HolderLookup.RegistryLookup registrylookup = this.level.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            tempTool.enchant((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), fortune);
        }
        BlockEvent.BreakEvent breakEvent = RenderBlockTileEntity.fixForgeEventBreakBlock(this.renderBlock, player, this.level, this.worldPosition, tempTool);
        NeoForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return;
        }
        List drops = Block.getDrops((BlockState)this.renderBlock, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition, null, (Entity)player, (ItemStack)tempTool);
        if (this.blockAllowed) {
            int exp = this.renderBlock.getExpDrop((LevelAccessor)this.level, this.worldPosition, null, (Entity)player, tempTool);
            boolean magnetMode = UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.MAGNET);
            for (ItemStack drop : drops) {
                if (drop == null) continue;
                if (magnetMode) {
                    ItemEntityPickupEvent.Pre wasPickedUp = EventHooks.fireItemPickupPre((ItemEntity)new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), drop), (Player)player);
                    if (wasPickedUp.canPickup() != TriState.DEFAULT || player.addItem(drop)) continue;
                    Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)drop);
                    continue;
                }
                Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)drop);
            }
            if (magnetMode) {
                if (exp > 0) {
                    player.giveExperiencePoints(exp);
                }
            } else if (exp > 0) {
                this.renderBlock.getBlock().popExperience((ServerLevel)this.level, this.worldPosition, exp);
            }
            this.renderBlock.spawnAfterBreak((ServerLevel)this.level, this.worldPosition, tempTool, false);
        }
        this.level.removeBlockEntity(this.worldPosition);
        this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
        player.awardStat(Stats.BLOCK_MINED.get((Object)this.renderBlock.getBlock()));
        if (SpecialBlockActions.getRegister().containsKey(this.renderBlock.getBlock())) {
            SpecialBlockActions.getRegister().get(this.renderBlock.getBlock()).accept((Object)this.level, (Object)this.worldPosition, (Object)this.renderBlock);
        }
    }

    private static BlockEvent.BreakEvent fixForgeEventBreakBlock(BlockState state, Player player, Level world, BlockPos pos, ItemStack tool) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        return event;
    }

    private void resetBlock() {
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide) {
            this.level.setBlockAndUpdate(this.worldPosition, Objects.requireNonNullElseGet(this.renderBlock, () -> ((Block)Blocks.AIR).defaultBlockState()));
        }
    }

    public void setBlockAllowed() {
        Optional<Upgrade> upgrade;
        if (!UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.VOID_JUNK)) {
            this.blockAllowed = true;
            return;
        }
        Player player = this.level.getPlayerByUUID(this.playerUUID);
        if (player == null) {
            return;
        }
        boolean silk = false;
        int fortune = 0;
        ItemStack tempTool = new ItemStack((ItemLike)Registration.MININGGADGET.get());
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.SILK)) {
            HolderLookup.RegistryLookup registrylookup = this.level.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            tempTool.enchant((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), 1);
            silk = true;
        }
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1) && (upgrade = UpgradeTools.getUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1)).isPresent()) {
            fortune = upgrade.get().getTier();
            HolderLookup.RegistryLookup registrylookup = this.level.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            tempTool.enchant((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), fortune);
        }
        List drops = Block.getDrops((BlockState)this.renderBlock, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition, null, (Entity)player, (ItemStack)tempTool);
        this.blockAllowed = RenderBlockTileEntity.blockAllowed(drops, this.getGadgetFilters(), this.isGadgetIsWhitelist());
    }

    public boolean getBlockAllowed() {
        return this.blockAllowed;
    }
}

