/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.food;

import com.mamailes.merrymaking.block.deco.base.HorizontalDecoBlock;
import com.mamailes.merrymaking.init.MMBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EdibleDinnerBlock
extends HorizontalDecoBlock {
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)7);
    protected static final VoxelShape NORTH_AABB = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)1.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0);
    protected static final VoxelShape MIDDLE_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final VoxelShape EW = Shapes.join((VoxelShape)WEST_AABB, (VoxelShape)EAST_AABB, (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape NS = Shapes.join((VoxelShape)NORTH_AABB, (VoxelShape)SOUTH_AABB, (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape NSEW = Shapes.join((VoxelShape)EW, (VoxelShape)NS, (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape ALL = Shapes.join((VoxelShape)NSEW, (VoxelShape)MIDDLE_AABB, (BooleanOp)BooleanOp.OR);

    public EdibleDinnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        return ALL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES, FACING});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (EdibleDinnerBlock.eat((LevelAccessor)level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return EdibleDinnerBlock.eat((LevelAccessor)level, pos, state, player);
    }

    protected static InteractionResult eat(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.getFoodData().eat(8, 0.8f);
        int i = (Integer)state.getValue((Property)BITES);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (i < 6) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
            level.setBlock(pos, (BlockState)((Block)MMBlocks.QUARTZ_PLATTER.get()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
        }
        return InteractionResult.SUCCESS;
    }
}

