/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.mantel.logs;

import com.mamailes.merrymaking.block.deco.base.HorizontalDecoBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Fireplace
extends HorizontalDecoBlock {
    protected static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final BooleanProperty BURNED = BooleanProperty.create((String)"burned");
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");

    public Fireplace(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)BURNED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)DIRECTION, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        Random random = new Random();
        stack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            if (stack.getItem() == Items.FLINT_AND_STEEL) {
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)BURNED, (Comparable)Boolean.valueOf(true)), 3);
                stack.setDamageValue(1);
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            if (((Boolean)state.getValue((Property)LIT)).booleanValue() && stack.getItem() == Items.WATER_BUCKET) {
                stack.shrink(1);
                player.getInventory().add(new ItemStack((ItemLike)Items.BUCKET));
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)BURNED, (Comparable)Boolean.TRUE));
                level.playSound((Player)null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, pHitResult);
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        switch ((Direction)state.getValue((Property)DIRECTION)) {
            case SOUTH: {
                return SOUTH_AABB;
            }
            default: {
                return NORTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: 
        }
        return EAST_AABB;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BURNED, LIT});
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean flag;
        if (!level.isClientSide && (flag = ((Boolean)state.getValue((Property)LIT)).booleanValue()) != level.hasNeighborSignal(pos)) {
            if (flag) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.cycle((Property)LIT)).setValue((Property)BURNED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.cycle((Property)LIT)).setValue((Property)BURNED, (Comparable)Boolean.TRUE));
        }
    }
}

