/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.core;

import com.almostreliable.unified.core.RecipeLoadCondition;
import com.almostreliable.unified.unification.recipe.RecipeLink;
import com.almostreliable.unified.unification.recipe.RecipeLinkFactory;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import org.jetbrains.annotations.Nullable;

public class ConditionalRecipeLinkFactory
implements RecipeLinkFactory {
    private final ConditionalOps<JsonElement> conOps;
    private final Codec<Optional<Unit>> codec;
    private final boolean cache;

    public ConditionalRecipeLinkFactory(ConditionalOps<JsonElement> conOps, boolean cache) {
        this.conOps = conOps;
        this.codec = ConditionalOps.createConditionalCodec((Codec)Unit.CODEC);
        this.cache = cache;
    }

    @Override
    @Nullable
    public RecipeLink create(ResourceLocation id, JsonObject originalRecipe) {
        JsonElement conditions = originalRecipe.get("neoforge:conditions");
        if (conditions == null) {
            return RecipeLink.of(id, originalRecipe);
        }
        try {
            boolean conditionsMet = ((Optional)this.codec.parse(this.conOps, (Object)originalRecipe).getOrThrow(JsonParseException::new)).isPresent();
            if (this.cache) {
                JsonObject conJson = new JsonObject();
                conJson.addProperty("type", RecipeLoadCondition.ID);
                conJson.addProperty("conditions_met", Boolean.valueOf(conditionsMet));
                conJson.add("original_conditions", conditions);
                JsonArray arr = new JsonArray();
                arr.add((JsonElement)conJson);
                originalRecipe.add("neoforge:conditions", (JsonElement)arr);
            }
            if (!conditionsMet) {
                return null;
            }
            return RecipeLink.of(id, originalRecipe);
        }
        catch (JsonParseException | IllegalArgumentException e) {
            return null;
        }
    }
}

