/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.DeleteAction;
import org.apache.logging.log4j.core.appender.rolling.action.IfFileName;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public final class CustomLogger {
    private static final String BACKUP_FILE = "almostunified-backup.log.gz";
    private static final String FILE = "almostunified.log";
    private static final String LOG_PATH = "logs/almostunified";

    private CustomLogger() {
    }

    public static Logger create() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        PathCondition[] conditions = new PathCondition[]{IfFileName.createNameCondition((String)BACKUP_FILE, null, (PathCondition[])new PathCondition[0])};
        DeleteAction deleteAction = DeleteAction.createDeleteAction((String)LOG_PATH, (boolean)false, (int)1, (boolean)false, null, (PathCondition[])conditions, null, (Configuration)config);
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withCustomActions(new Action[]{deleteAction}).build();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withCharset(StandardCharsets.UTF_8).withPattern("[%d{HH:mm:ss.SSS}] [%level]: %minecraftFormatting{%msg{nolookup}}{strip}%n%xEx").build();
        RollingRandomAccessFileAppender fileAppender = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().withAppend(true).withFileName("logs/almostunified/almostunified.log").withFilePattern("logs/almostunified/almostunified-backup.log.gz").withStrategy((RolloverStrategy)strategy).withPolicy((TriggeringPolicy)new Policy()).setName("AlmostUnified File")).setLayout((Layout)layout)).setConfiguration(config)).build();
        fileAppender.start();
        LoggerConfig loggerConfig = new LoggerConfig("AlmostUnified", null, false);
        loggerConfig.addAppender((Appender)fileAppender, null, null);
        Optional.ofNullable((Appender)config.getAppenders().get("Console")).ifPresent(a -> loggerConfig.addAppender(a, null, null));
        Optional.ofNullable((Appender)config.getAppenders().get("SysOut")).ifPresent(a -> loggerConfig.addAppender(a, null, null));
        Optional.ofNullable((Appender)config.getAppenders().get("ServerGuiConsole")).ifPresent(a -> loggerConfig.addAppender(a, null, null));
        config.addLogger("AlmostUnified", loggerConfig);
        return LogManager.getLogger((String)"AlmostUnified");
    }

    private static class Policy
    implements TriggeringPolicy {
        private boolean reset = true;

        private Policy() {
        }

        public void initialize(RollingFileManager manager) {
        }

        public boolean isTriggeringEvent(LogEvent logEvent) {
            if (this.reset) {
                this.reset = false;
                return true;
            }
            return false;
        }
    }
}

