/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.RegistryEntries;

public class BlockFluidBlood
extends LiquidBlock {
    private static final int CHANCE_HARDEN = 3;

    public BlockFluidBlood(BlockBehaviour.Properties builder) {
        super((FlowingFluid)RegistryEntries.FLUID_BLOOD.get(), builder);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)LEVEL) == 0;
    }

    public void randomTick(BlockState blockState, ServerLevel world, BlockPos blockPos, RandomSource random) {
        if (!(random.nextInt(3) != 0 || (Integer)blockState.getValue((Property)LEVEL) != 0 || world.isRaining() && ((Biome)world.getBiome(blockPos).value()).hasPrecipitation() && world.canSeeSkyFromBelowWater(blockPos) || this.isWaterInArea((Level)world, blockPos))) {
            world.setBlock(blockPos, ((Block)RegistryEntries.BLOCK_HARDENED_BLOOD.get()).defaultBlockState(), 2);
        }
        super.randomTick(blockState, world, blockPos, random);
    }

    protected boolean isWaterInArea(Level world, BlockPos blockPos) {
        return (Boolean)WorldHelpers.foldArea((LevelAccessor)world, (int)4, (BlockPos)blockPos, (input, world1, blockPos1) -> input != false || world1.getBlockState(blockPos1).getBlock() == Blocks.WATER, (Object)false);
    }
}

