/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.effect;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

public class EntityAntiVengeanceBeam
extends ThrowableProjectile {
    private static final int MAX_AGE = 200;
    private int age = 0;
    private int soundTick = 0;

    public EntityAntiVengeanceBeam(EntityType<? extends EntityAntiVengeanceBeam> type, Level world) {
        super(type, world);
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.25, 0.25, 0.25));
    }

    public EntityAntiVengeanceBeam(EntityType<? extends EntityAntiVengeanceBeam> type, Level world, LivingEntity entity) {
        super(type, entity, world);
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.25, 0.25, 0.25));
    }

    public EntityAntiVengeanceBeam(Level world, LivingEntity entity) {
        super((EntityType)RegistryEntries.ENTITY_ANTI_VENGEANCE_BEAM.get(), entity, world);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), entity -> !entity.isSpectator() && entity.isAlive() && entity.isPickable() && entity != this.getOwner());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        Vec3 motion = this.getDeltaMovement();
        Vec3 vec3 = new Vec3(this.getX(), this.getY(), this.getZ());
        Vec3 vec31 = new Vec3(this.getX(), this.getY(), this.getZ()).add(motion);
        EntityHitResult entityRayTraceResult = this.rayTraceEntities(vec3, vec31);
        vec3 = new Vec3(this.getX(), this.getY(), this.getZ());
        vec31 = new Vec3(this.getX(), this.getY(), this.getZ()).add(motion);
        ++this.soundTick;
        if (this.soundTick > 3 && this.getId() % 10 == 0) {
            this.soundTick = 0;
        }
        if (!this.level().isClientSide()) {
            Entity entity = null;
            List list = this.level().getEntities((Entity)this, this.getBoundingBox().move(motion).inflate(1.0));
            double d0 = 0.0;
            for (Entity entity1 : list) {
                double d1;
                if (!(entity1 instanceof EntityVengeanceSpirit)) continue;
                float f = 0.3f;
                AABB axisalignedbb = entity1.getBoundingBox().inflate((double)f);
                EntityHitResult movingobjectposition1 = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)vec3, (Vec3)vec31, (AABB)axisalignedbb, e -> true);
                if (movingobjectposition1 == null || !((d1 = vec3.distanceTo(movingobjectposition1.getLocation())) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                entityRayTraceResult = new EntityHitResult(entity);
            }
        } else {
            for (int i = 0; i < this.level().random.nextInt(5) + 5; ++i) {
                this.showNewBlurParticle();
            }
            if (this.soundTick == 1) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)RegistryEntries.SOUNDEVENT_EFFECT_VENGEANCEBEAM_BASE.get(), SoundSource.NEUTRAL, 0.5f + this.level().random.nextFloat() * 0.2f, 1.0f, false);
            }
        }
        if (entityRayTraceResult != null) {
            this.onHit((HitResult)entityRayTraceResult);
        }
        if (this.age++ > 200) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        super.tick();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showNewBlurParticle() {
        float scale = 0.6f - this.random.nextFloat() * 0.3f;
        float red = this.random.nextFloat() * 0.03f + 0.01f;
        float green = this.random.nextFloat() * 0.03f;
        float blue = this.random.nextFloat() * 0.05f + 0.05f;
        float ageMultiplier = (float)(this.random.nextDouble() * 6.5 + 4.0);
        Vec3 motion = this.getDeltaMovement();
        Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, this.getX(), this.getY(), this.getZ(), this.deriveMotion(motion.x), this.deriveMotion(motion.y), this.deriveMotion(motion.z));
    }

    private double deriveMotion(double motion) {
        return motion * 0.5 + (0.02 - this.random.nextDouble() * 0.04);
    }

    protected void applyHitEffect(Entity entity) {
        if (entity instanceof EntityVengeanceSpirit) {
            EntityVengeanceSpirit spirit = (EntityVengeanceSpirit)entity;
            Vec3 motion = this.getDeltaMovement();
            spirit.onHit(this.getX(), this.getY(), this.getZ(), motion.x, motion.y, motion.z);
            Entity entity2 = this.getOwner();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer owner = (ServerPlayer)entity2;
                spirit.addEntanglingPlayer(owner);
            }
        }
    }

    protected void onHit(HitResult position) {
        if (!this.level().isClientSide() && position.getType() == HitResult.Type.ENTITY && this.getOwner() != null && this.getOwner() instanceof Player) {
            this.applyHitEffect(((EntityHitResult)position).getEntity());
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }
}

