/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritReanimator;
import org.cyclops.evilcraft.gametest.GameTestsSpiritFurnace;

@GameTestHolder(value="evilcraft")
@PrefixGameTestTemplate(value=false)
public class GameTestsSpiritReanimator {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="empty10", timeoutTicks=150)
    public void testSpiritReanimatorChicken(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_SPIRIT_REANIMATOR.get());
        BlockEntitySpiritReanimator reanimator = (BlockEntitySpiritReanimator)helper.getBlockEntity(POS);
        reanimator.getInventory().setItem(1, GameTestsSpiritFurnace.createBox(helper, EntityType.CHICKEN));
        reanimator.getInventory().setItem(2, new ItemStack((ItemLike)Items.EGG));
        reanimator.getInventory().setItem(4, new ItemStack(RegistryEntries.ITEM_PROMISE_SPEED, 4));
        helper.setBlock(POS.above(), (Block)RegistryEntries.BLOCK_DARK_TANK.get());
        BlockEntityDarkTank tank = (BlockEntityDarkTank)helper.getBlockEntity(POS.above());
        tank.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 8000));
        tank.setEnabled(true);
        helper.succeedWhen(() -> {
            helper.assertFalse(reanimator.getInventory().getItem(1).has(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA), "Box has not been cleared");
            helper.assertTrue(reanimator.getInventory().getItem(2).isEmpty(), "Egg has not been consumed");
            helper.assertFalse(reanimator.getInventory().getItem(3).isEmpty(), "Output is not present");
            helper.assertValueEqual((Object)reanimator.getInventory().getItem(3).getItem(), (Object)Items.CHICKEN_SPAWN_EGG, "Output is not a chicken spawn egg");
        });
    }
}

