/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;
import org.cyclops.evilcraft.item.ItemVengeanceRingConfig;

public class ItemVengeanceRing
extends Item {
    private static final int BONUS_TICK_MODULUS = 5;
    private static final int BONUS_POTION_DURATION = 60;
    private static final List<Triple<Holder<MobEffect>, Integer, Integer>> RING_POWERS = Lists.newArrayList((Object[])new Triple[]{Triple.of((Object)MobEffects.JUMP, (Object)60, (Object)2), Triple.of((Object)MobEffects.INVISIBILITY, (Object)60, (Object)1), Triple.of((Object)MobEffects.MOVEMENT_SPEED, (Object)60, (Object)1), Triple.of((Object)MobEffects.DIG_SPEED, (Object)60, (Object)1)});

    public ItemVengeanceRing(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.isCrouching()) {
            if (!world.isClientSide()) {
                ItemHelpers.toggleActivation(itemStack);
            }
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        return super.use(world, player, hand);
    }

    public boolean isFoil(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    public static void toggleVengeanceArea(Level world, Entity entity, int area, boolean enableVengeance, boolean spawnRandom, boolean forceGlobal) {
        if (world.getDifficulty() != Difficulty.PEACEFUL) {
            EntityVengeanceSpirit spirit;
            double x = entity.getX();
            double y = entity.getY();
            double z = entity.getZ();
            BlockPos blockPos = entity.blockPosition();
            AABB box = new AABB(x, y, z, x, y, z).inflate((double)area, (double)area, (double)area);
            List spirits = world.getEntitiesOfClass(EntityVengeanceSpirit.class, box, (Predicate)new com.google.common.base.Predicate<Entity>(){

                public boolean apply(Entity entity) {
                    return entity instanceof EntityVengeanceSpirit;
                }
            });
            for (EntityVengeanceSpirit spirit2 : spirits) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                spirit2.setEnabledVengeance(player, enableVengeance);
                if (enableVengeance) {
                    spirit2.setTarget((LivingEntity)player);
                    continue;
                }
                if (spirit2.getTarget() != player) continue;
                spirit2.setTarget(null);
            }
            if (spirits.size() == 0 && enableVengeance && (spirit = EntityVengeanceSpirit.spawnRandom(world, blockPos, area / 4)) != null) {
                int chance;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (forceGlobal) {
                        spirit.setGlobalVengeance(true);
                    } else {
                        spirit.setEnabledVengeance(player, true);
                    }
                    spirit.setTarget((LivingEntity)player);
                }
                spirit.setSwarm((chance = EntityVengeanceSpiritConfig.nonDegradedSpawnChance) <= 0 || world.random.nextInt(chance) > 0);
            }
        }
    }

    public static void updateRingPowers(Player player) {
        for (Triple<Holder<MobEffect>, Integer, Integer> power : RING_POWERS) {
            player.addEffect(new MobEffectInstance((Holder)power.getLeft(), ((Integer)power.getMiddle()).intValue(), ((Integer)power.getRight()).intValue(), false, true));
        }
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int par4, boolean par5) {
        if (entity instanceof Player && !world.isClientSide() && WorldHelpers.efficientTick((Level)world, (int)5, (int[])new int[]{entity.getId()})) {
            int area = ItemVengeanceRingConfig.areaOfEffect;
            ItemVengeanceRing.toggleVengeanceArea(world, entity, area, ItemHelpers.isActivated(itemStack), true, false);
            if (ItemHelpers.isActivated(itemStack)) {
                ItemVengeanceRing.updateRingPowers((Player)entity);
            }
        }
        super.inventoryTick(itemStack, world, entity, par4, par5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.getDescriptionId() + ".info.status"));
    }
}

